/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1163", name="Exceptions should not be thrown in finally blocks", tags={"error-handling"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="30min")
public class ThrowsFromFinallyCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private int finallyLevel = 0;
    private boolean isInMethodWithinFinally;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resources());
        this.scan((Tree)tree.block());
        this.scan(tree.catches());
        ++this.finallyLevel;
        this.scan((Tree)tree.finallyBlock());
        --this.finallyLevel;
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        if (this.isInFinally() && !this.isInMethodWithinFinally) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Refactor this code to not throw exceptions in finally blocks.");
        }
        super.visitThrowStatement(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.isInMethodWithinFinally = this.isInFinally();
        super.visitMethod(tree);
        this.isInMethodWithinFinally = false;
    }

    private boolean isInFinally() {
        return this.finallyLevel > 0;
    }
}

