/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1158", name="Primitive wrappers should not be instantiated only to perform a \"toString\" conversion", tags={"clumsy"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class ToStringUsingBoxingCheck
extends SubscriptionBaseVisitor {
    private static final Set<String> PRIMITIVE_WRAPPERS = ImmutableSet.of((Object)"Byte", (Object)"Short", (Object)"Integer", (Object)"Long", (Object)"Float", (Object)"Double", (Object[])new String[]{"Character", "Boolean"});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        String newlyCreatedClassName;
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (this.isCallingToString(mit) && PRIMITIVE_WRAPPERS.contains(newlyCreatedClassName = this.getNewlyCreatedClassName(mit))) {
            this.addIssue((Tree)((MemberSelectExpressionTree)mit.methodSelect()).expression(), "Call the static method " + newlyCreatedClassName + ".toString(...) instead of instantiating a temporary object to perform this to string conversion.");
        }
    }

    private String getNewlyCreatedClassName(MethodInvocationTree mit) {
        MemberSelectExpressionTree mset = (MemberSelectExpressionTree)mit.methodSelect();
        if (mset.expression().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            TypeTree classId = ((NewClassTree)mset.expression()).identifier();
            if (classId.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return ((IdentifierTree)classId).name();
            }
            if (classId.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return ((MemberSelectExpressionTree)classId).identifier().name();
            }
        }
        return "";
    }

    private boolean isCallingToString(MethodInvocationTree mit) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)mit.methodSelect();
            return "toString".equals(mset.identifier().name());
        }
        return false;
    }
}

