/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.CommentContainsPatternChecker;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1135", name="\"TODO\" tags should be handled", priority=Priority.INFO)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class TodoTagPresenceCheck
extends SubscriptionBaseVisitor {
    private static final String PATTERN = "TODO";
    private static final String MESSAGE = "Complete the task associated to this TODO comment.";
    private final CommentContainsPatternChecker checker = new CommentContainsPatternChecker(this, "TODO", "Complete the task associated to this TODO comment.");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRIVIA);
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        this.checker.checkTrivia(syntaxTrivia);
    }
}

