/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00107", name="Methods should not have too many parameters", tags={"brain-overload"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="20min")
public class TooManyParameters_S00107_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAXIMUM = 7;
    @RuleProperty(key="max", description="Maximum authorized number of parameters", defaultValue="7")
    public int maximum = 7;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        int count = tree.parameters().size();
        if (count > this.maximum) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Method has " + count + " parameters, which is greater than " + this.maximum + " authorized.");
        }
        super.visitMethod(tree);
    }
}

