/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2677", name="\"read\" and \"readLine\" return values should be used", tags={"bug"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedReturnedDataCheck
extends SubscriptionBaseVisitor {
    private static final List<MethodInvocationMatcher> CHECKED_METHODS = ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.io.BufferedReader")).name("readLine"), (Object)MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.io.Reader")).name("read"));

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT, (Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            for (MethodInvocationMatcher matcher : CHECKED_METHODS) {
                Symbol symbol = this.isTreeMethodInvocation(((ExpressionStatementTree)tree).expression(), matcher);
                if (symbol == null) continue;
                this.raiseIssue(tree, symbol.name());
            }
        } else {
            BinaryExpressionTree expressionTree = (BinaryExpressionTree)tree;
            for (MethodInvocationMatcher matcher : CHECKED_METHODS) {
                Symbol rightSymbol;
                Symbol leftSymbol = this.isTreeMethodInvocation(expressionTree.leftOperand(), matcher);
                if (leftSymbol != null && this.isTreeLiteralNull(expressionTree.rightOperand())) {
                    this.raiseIssue(tree, leftSymbol.name());
                }
                if ((rightSymbol = this.isTreeMethodInvocation(expressionTree.rightOperand(), matcher)) == null || !this.isTreeLiteralNull(expressionTree.leftOperand())) continue;
                this.raiseIssue(tree, rightSymbol.name());
            }
        }
    }

    @CheckForNull
    private Symbol isTreeMethodInvocation(ExpressionTree tree, MethodInvocationMatcher matcher) {
        MethodInvocationTree methodInvocation;
        ExpressionTree expression = this.removeParenthesis(tree);
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && matcher.matches(methodInvocation = (MethodInvocationTree)expression)) {
            return methodInvocation.symbol();
        }
        return null;
    }

    private boolean isTreeLiteralNull(ExpressionTree tree) {
        return this.removeParenthesis(tree).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private ExpressionTree removeParenthesis(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (result.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    private void raiseIssue(Tree tree, String methodName) {
        this.addIssue(tree, String.format("Use or store the value returned from \"%s\" instead of throwing it away.", methodName));
    }
}

