/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="UselessImportCheck", name="Useless imports should be removed", tags={"unused"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class UselessImportCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Map<String, Integer> lineByImportReference = Maps.newHashMap();
    private final Set<String> pendingImports = Sets.newHashSet();
    private final Set<String> pendingReferences = Sets.newHashSet();
    private String currentPackage;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        CompilationUnitTree cut = context.getTree();
        this.pendingReferences.clear();
        this.lineByImportReference.clear();
        this.pendingImports.clear();
        this.currentPackage = this.concatenate(cut.packageName());
        for (ImportTree importTree : cut.imports()) {
            if (importTree.isStatic()) continue;
            String importName = this.concatenate((ExpressionTree)importTree.qualifiedIdentifier());
            if ("java.lang.*".equals(importName)) {
                context.addIssue((Tree)importTree, (JavaCheck)this, "Remove this unnecessary import: java.lang classes are always implicitly imported.");
                continue;
            }
            if (this.isImportFromSamePackage(importName)) {
                context.addIssue((Tree)importTree, (JavaCheck)this, "Remove this unnecessary import: same package classes are always implicitly imported.");
                continue;
            }
            if (this.isImportOnDemand(importName)) continue;
            if (this.isJavaLangImport(importName)) {
                context.addIssue((Tree)importTree, (JavaCheck)this, "Remove this unnecessary import: java.lang classes are always implicitly imported.");
                continue;
            }
            if (this.isDuplicatedImport(importName)) {
                context.addIssue((Tree)importTree, (JavaCheck)this, "Remove this duplicated import.");
                continue;
            }
            this.lineByImportReference.put(importName, ((JavaTree)importTree).getLine());
            this.pendingImports.add(importName);
        }
        this.scan((Tree)cut);
        new CommentVisitor().checkImportsFromComments(cut, this.pendingImports);
        this.leaveFile();
    }

    private boolean isImportOnDemand(String name) {
        return name.endsWith("*");
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.scan(tree.packageAnnotations());
        this.scan(tree.types());
    }

    public void visitIdentifier(IdentifierTree tree) {
        this.pendingReferences.add(tree.name());
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.pendingReferences.add(this.concatenate((ExpressionTree)tree));
        if (!tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.scan((Tree)tree.expression());
        }
    }

    private boolean isImportFromSamePackage(String reference) {
        String importName = reference;
        if (this.isImportOnDemand(reference)) {
            importName = reference.substring(0, reference.length() - 2);
        }
        return !this.currentPackage.isEmpty() && importName.startsWith(this.currentPackage) && (importName.length() == this.currentPackage.length() || reference.substring(reference.indexOf(this.currentPackage)).startsWith("."));
    }

    private boolean isDuplicatedImport(String reference) {
        return this.pendingImports.contains(reference);
    }

    private boolean isJavaLangImport(String reference) {
        return reference.startsWith("java.lang.") && reference.indexOf(46, "java.lang.".length()) == -1;
    }

    public void leaveFile() {
        for (String reference : this.pendingReferences) {
            this.updatePendingImports(reference);
        }
        for (String pendingImport : this.pendingImports) {
            this.context.addIssue(this.lineByImportReference.get(pendingImport).intValue(), (JavaCheck)this, "Remove this unused import '" + pendingImport + "'.");
        }
    }

    private void updatePendingImports(String reference) {
        String firstClassReference = reference;
        if (UselessImportCheck.isFullyQualified(firstClassReference)) {
            firstClassReference = UselessImportCheck.extractFirstClassName(firstClassReference);
        }
        Iterator<String> it = this.pendingImports.iterator();
        while (it.hasNext()) {
            String pendingImport = it.next();
            if (!pendingImport.endsWith("." + firstClassReference)) continue;
            it.remove();
        }
    }

    private static boolean isFullyQualified(String reference) {
        return reference.indexOf(46) != -1;
    }

    private static String extractFirstClassName(String reference) {
        int firstIndexOfDot = reference.indexOf(46);
        return firstIndexOfDot == -1 ? reference : reference.substring(0, firstIndexOfDot);
    }

    private String concatenate(@Nullable ExpressionTree tree) {
        if (tree == null) {
            return "";
        }
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }

    private static class CommentVisitor
    extends SubscriptionBaseVisitor {
        private Set<String> pendingImports;

        private CommentVisitor() {
        }

        public List<Tree.Kind> nodesToVisit() {
            return ImmutableList.of((Object)Tree.Kind.TRIVIA);
        }

        public void checkImportsFromComments(CompilationUnitTree cut, Set<String> pendingImports) {
            this.pendingImports = pendingImports;
            this.visitTokens(cut);
        }

        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            this.updatePendingImportsForComments(syntaxTrivia.comment());
        }

        private void updatePendingImportsForComments(String comment) {
            Iterator<String> it = this.pendingImports.iterator();
            while (it.hasNext()) {
                String pendingImport = it.next();
                if (!comment.contains(this.extractLastClassName(pendingImport))) continue;
                it.remove();
            }
        }

        private String extractLastClassName(String reference) {
            int lastIndexOfDot = reference.lastIndexOf(46);
            return lastIndexOfDot == -1 ? reference : reference.substring(lastIndexOfDot + 1);
        }
    }
}

