/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.WildcardTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1452", name="Generic wildcard types should not be used in return parameters", tags={"pitfall"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class WildcardReturnParameterTypeCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (!this.isPrivate(methodTree) && !this.isOverriding(methodTree)) {
            methodTree.returnType().accept((TreeVisitor)new CheckWildcard());
        }
    }

    private boolean isPrivate(MethodTree methodTree) {
        return methodTree.modifiers().modifiers().contains(Modifier.PRIVATE);
    }

    private boolean isOverriding(MethodTree tree) {
        return BooleanUtils.isTrue((Boolean)((MethodTreeImpl)tree).isOverriding());
    }

    private class CheckWildcard
    extends BaseTreeVisitor {
        private boolean classType = false;

        private CheckWildcard() {
        }

        public void visitParameterizedType(ParameterizedTypeTree tree) {
            this.classType = tree.type().symbolType().is("java.lang.Class");
            super.visitParameterizedType(tree);
            this.classType = false;
        }

        public void visitWildcard(WildcardTree tree) {
            if (!this.classType) {
                WildcardReturnParameterTypeCheck.this.addIssue((Tree)tree, "Remove usage of generic wildcard type.");
            }
        }
    }
}

