/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.methods;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractMethodDetection
extends SubscriptionBaseVisitor {
    private List<MethodInvocationMatcher> matchers;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            for (MethodInvocationMatcher invocationMatcher : this.matchers()) {
                this.checkInvocation(tree, invocationMatcher);
            }
        }
    }

    private void checkInvocation(Tree tree, MethodInvocationMatcher invocationMatcher) {
        NewClassTree newClassTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (invocationMatcher.matches(mit)) {
                this.onMethodFound(mit);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && invocationMatcher.matches(newClassTree = (NewClassTree)tree)) {
            this.onConstructorFound(newClassTree);
        }
    }

    protected abstract List<MethodInvocationMatcher> getMethodInvocationMatchers();

    protected void onMethodFound(MethodInvocationTree mit) {
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
    }

    private List<MethodInvocationMatcher> matchers() {
        if (this.matchers == null) {
            this.matchers = this.getMethodInvocationMatchers();
        }
        return this.matchers;
    }
}

