/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterLiteralChannel
extends Channel<Lexer> {
    private final StringBuilder sb = new StringBuilder();
    private final char ch;
    private final TokenType tokenType;
    private final Token.Builder tokenBuilder = Token.builder();

    public CharacterLiteralChannel(char ch, TokenType tokenType) {
        this.ch = ch;
        this.tokenType = tokenType;
    }

    public boolean consume(CodeReader code, Lexer lexer) {
        if (code.peek() != this.ch) {
            return false;
        }
        int line = code.getCursor().getLine();
        int column = code.getCursor().getColumn();
        do {
            char prev = (char)code.pop();
            this.sb.append(prev);
            if (prev != '\\') continue;
            prev = (char)code.pop();
            this.sb.append(prev);
        } while (code.peek() != this.ch);
        this.sb.append((char)code.pop());
        String value = this.sb.toString();
        Token token = this.tokenBuilder.setType(this.tokenType).setValueAndOriginalValue(value).setURI(lexer.getURI()).setLine(line).setColumn(column).build();
        lexer.addToken(new Token[]{token});
        this.sb.delete(0, this.sb.length());
        return true;
    }
}

