/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import java.util.List;
import org.sonar.java.ast.api.JavaGrammar;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class AccessorVisitor
extends JavaAstVisitor {
    public void init() {
        MethodHelper.subscribe(this);
    }

    public void visitNode(AstNode astNode) {
        MethodHelper methodHelper;
        SourceMethod sourceMethod = (SourceMethod)this.getContext().peekSourceCode();
        if (astNode.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).methodDeclaratorRest, ((JavaGrammar)this.getContext().getGrammar()).voidMethodDeclaratorRest, ((JavaGrammar)this.getContext().getGrammar()).constructorDeclaratorRest}) && (methodHelper = new MethodHelper((JavaGrammar)this.getContext().getGrammar(), astNode)).isPublic() && this.isAccessor(methodHelper)) {
            sourceMethod.setMeasure((MetricDef)Metric.ACCESSORS, 1);
        }
    }

    public void leaveNode(AstNode astNode) {
        SourceMethod sourceMethod = (SourceMethod)this.getContext().peekSourceCode();
        if (sourceMethod.isAccessor()) {
            sourceMethod.setMeasure((MetricDef)Metric.PUBLIC_API, 0);
            sourceMethod.setMeasure((MetricDef)Metric.PUBLIC_DOC_API, 0);
            sourceMethod.setMeasure((MetricDef)JavaMetric.METHODS, 0);
            sourceMethod.setMeasure((MetricDef)JavaMetric.COMPLEXITY, 0);
        }
    }

    private boolean isAccessor(MethodHelper method) {
        return this.isValidGetter(method) || this.isValidSetter(method) || this.isValidBooleanGetter(method);
    }

    private boolean isValidGetter(MethodHelper method) {
        List<AstNode> statements;
        String methodName = method.getName().getTokenValue();
        if (methodName.startsWith("get") && !method.hasParameters() && !method.getReturnType().is(new AstNodeType[]{JavaKeyword.VOID}) && (statements = method.getStatements()).size() == 1) {
            AstNode blockStatement = statements.get(0);
            Preconditions.checkState((boolean)blockStatement.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).blockStatement}));
            return this.inspectGetterMethodBody(blockStatement.getFirstChild().getFirstChild());
        }
        return false;
    }

    private boolean isValidSetter(MethodHelper method) {
        List<AstNode> statements;
        String methodName = method.getName().getTokenValue();
        if (methodName.startsWith("set") && method.getParameters().size() == 1 && method.getReturnType().is(new AstNodeType[]{JavaKeyword.VOID}) && (statements = method.getStatements()).size() == 1) {
            AstNode blockStatement = statements.get(0);
            Preconditions.checkState((boolean)blockStatement.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).blockStatement}));
            return this.inspectSetterMethodBody(blockStatement.getFirstChild().getFirstChild());
        }
        return false;
    }

    private boolean inspectSetterMethodBody(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).expressionStatement})) {
            AstNode expression = astNode.findFirstChild(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).expression});
            AstNode assignmentExpression = expression.getFirstChild();
            if (assignmentExpression.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).assignmentExpression})) {
                AstNode varToAssign = assignmentExpression.findFirstChild(new AstNodeType[]{GenericTokenType.IDENTIFIER});
                return this.findPrivateClassVariable(varToAssign);
            }
        }
        return false;
    }

    private boolean isValidBooleanGetter(MethodHelper method) {
        List<AstNode> statements;
        String methodName = method.getName().getTokenValue();
        if (methodName.startsWith("is") && !method.hasParameters() && this.hasBooleanReturnType(method) && (statements = method.getStatements()).size() == 1) {
            AstNode blockStatement = statements.get(0);
            Preconditions.checkState((boolean)blockStatement.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).blockStatement}));
            return this.inspectGetterMethodBody(blockStatement.getFirstChild().getFirstChild());
        }
        return false;
    }

    private boolean inspectGetterMethodBody(AstNode astNode) {
        AstNode varReturned;
        AstNode qualifiedIdentifier;
        AstNode primary;
        AstNode expression;
        return astNode.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).returnStatement}) && astNode.hasDirectChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).expression}) && (expression = astNode.findFirstDirectChild(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).expression})).getNumberOfChildren() == 1 && expression.getFirstChild().is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).primary}) && (primary = expression.getFirstChild()).getNumberOfChildren() == 1 && primary.getFirstChild().is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).qualifiedIdentifier}) && (qualifiedIdentifier = primary.getFirstChild()).getNumberOfChildren() == 1 && this.findPrivateClassVariable(varReturned = qualifiedIdentifier.getFirstChild());
    }

    private boolean findPrivateClassVariable(AstNode varReturned) {
        AstNode classBody = varReturned.findFirstParent((AstNodeType)((JavaGrammar)this.getContext().getGrammar()).classBodyDeclaration).getParent();
        for (AstNode classBodyDeclaration : classBody.findDirectChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).classBodyDeclaration})) {
            if (!this.hasPrivateModifier(classBodyDeclaration)) continue;
            for (AstNode memberDecl : classBodyDeclaration.findDirectChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).memberDecl})) {
                if (!memberDecl.getFirstChild().is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).fieldDeclaration})) continue;
                for (AstNode variableDeclarator : memberDecl.findChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).variableDeclarator})) {
                    if (!varReturned.getTokenValue().equals(variableDeclarator.getFirstChild().getTokenValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasPrivateModifier(AstNode classBodyDeclaration) {
        for (AstNode modifierNode : classBodyDeclaration.findDirectChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).modifier})) {
            if (!modifierNode.getChild(0).is(new AstNodeType[]{JavaKeyword.PRIVATE})) continue;
            return true;
        }
        return false;
    }

    private boolean hasBooleanReturnType(MethodHelper method) {
        AstNode node = method.getReturnType();
        return node.getChildren().size() == 1 && node.getChild(0).getChild(0).is(new AstNodeType[]{JavaKeyword.BOOLEAN});
    }
}

