/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import org.sonar.java.ast.api.JavaGrammar;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicApiVisitor
extends JavaAstVisitor {
    public void init() {
        PublicApiVisitor.subscribe(this);
    }

    public static void subscribe(JavaAstVisitor visitor) {
        JavaGrammar grammar = (JavaGrammar)visitor.getContext().getGrammar();
        visitor.subscribeTo(new AstNodeType[]{grammar.classDeclaration, grammar.interfaceDeclaration, grammar.enumDeclaration, grammar.annotationTypeDeclaration, grammar.fieldDeclaration, grammar.constructorDeclaratorRest, grammar.methodDeclaratorRest, grammar.voidMethodDeclaratorRest, grammar.interfaceMethodDeclaratorRest, grammar.voidInterfaceMethodDeclaratorsRest, grammar.annotationMethodRest});
    }

    public void visitNode(AstNode astNode) {
        SourceCode currentResource = this.getContext().peekSourceCode();
        if (this.isPublicApi(astNode)) {
            currentResource.add((MetricDef)Metric.PUBLIC_API, 1.0);
            if (this.isDocumentedApi(astNode)) {
                currentResource.add((MetricDef)Metric.PUBLIC_DOC_API, 1.0);
            }
        }
    }

    private boolean isPublicApi(AstNode astNode) {
        return this.isPublic(astNode) && !this.isStaticFinalVariable(astNode) && !this.isMethodWithOverrideAnnotation(astNode) && !this.isEmptyDefaultConstructor(astNode);
    }

    private boolean isEmptyDefaultConstructor(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).constructorDeclaratorRest})) {
            MethodHelper method = new MethodHelper((JavaGrammar)this.getContext().getGrammar(), astNode);
            return !method.hasParameters() && method.getStatements().isEmpty();
        }
        return false;
    }

    private boolean isMethodWithOverrideAnnotation(AstNode astNode) {
        if (this.isMethod(astNode)) {
            return this.hasAnnotation(astNode, "Override") || this.hasAnnotation(astNode, "java.lang.Override");
        }
        return false;
    }

    private boolean hasAnnotation(AstNode astNode, String expected) {
        AstNode declaration = this.getDeclaration(astNode);
        for (AstNode modifier : this.getModifiers(declaration)) {
            AstNode annotation = modifier.findFirstDirectChild(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).annotation});
            if (annotation == null) continue;
            StringBuilder value = new StringBuilder();
            for (AstNode identifier : annotation.findFirstDirectChild(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).qualifiedIdentifier}).getChildren()) {
                value.append(identifier.getTokenValue());
            }
            if (!value.toString().equals(expected)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethod(AstNode astNode) {
        JavaGrammar grammar = (JavaGrammar)this.getContext().getGrammar();
        return astNode.is(new AstNodeType[]{grammar.methodDeclaratorRest, grammar.voidMethodDeclaratorRest, grammar.interfaceMethodDeclaratorRest, grammar.voidInterfaceMethodDeclaratorsRest, grammar.annotationMethodRest});
    }

    private boolean isStaticFinalVariable(AstNode astNode) {
        AstNode declaration = this.getDeclaration(astNode);
        return astNode.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).fieldDeclaration, ((JavaGrammar)this.getContext().getGrammar()).constantDeclaratorsRest}) && this.hasModifier(declaration, (AstNodeType)JavaKeyword.STATIC) && this.hasModifier(declaration, (AstNodeType)JavaKeyword.FINAL);
    }

    private boolean isDocumentedApi(AstNode astNode) {
        AstNode declaration = this.getDeclaration(astNode);
        for (Trivia trivia : declaration.getToken().getTrivia()) {
            String value;
            if (!trivia.isComment() || !(value = trivia.getToken().getOriginalValue()).startsWith("/**")) continue;
            return true;
        }
        return false;
    }

    private boolean isPublic(AstNode astNode) {
        AstNode declaration = this.getDeclaration(astNode);
        return declaration.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).annotationTypeElementDeclaration}) || declaration.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).interfaceBodyDeclaration}) || this.hasModifier(declaration, (AstNodeType)JavaKeyword.PUBLIC);
    }

    private boolean hasModifier(AstNode declaration, AstNodeType astNodeType) {
        for (AstNode modifier : this.getModifiers(declaration)) {
            if (!modifier.getFirstChild().is(new AstNodeType[]{astNodeType})) continue;
            return true;
        }
        return false;
    }

    private List<AstNode> getModifiers(AstNode declaration) {
        return declaration.findDirectChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).modifier});
    }

    private AstNode getDeclaration(AstNode astNode) {
        return PublicApiVisitor.getDeclaration((JavaGrammar)this.getContext().getGrammar(), astNode);
    }

    public static AstNode getDeclaration(JavaGrammar grammar, AstNode astNode) {
        AstNode declaration;
        if (astNode.getParent().is(new AstNodeType[]{grammar.memberDecl})) {
            declaration = astNode.getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{grammar.classBodyDeclaration}));
        } else if (astNode.getParent().is(new AstNodeType[]{grammar.genericMethodOrConstructorRest})) {
            declaration = astNode.getParent().getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{grammar.classBodyDeclaration}));
        } else if (astNode.getParent().is(new AstNodeType[]{grammar.interfaceMemberDecl})) {
            declaration = astNode.getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{grammar.interfaceBodyDeclaration}));
        } else if (astNode.getParent().is(new AstNodeType[]{grammar.interfaceMethodOrFieldRest})) {
            declaration = astNode.getParent().getParent().getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{grammar.interfaceBodyDeclaration}));
        } else if (astNode.getParent().is(new AstNodeType[]{grammar.interfaceGenericMethodDecl})) {
            declaration = astNode.getParent().getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{grammar.interfaceBodyDeclaration}));
        } else if (astNode.getParent().is(new AstNodeType[]{grammar.annotationMethodOrConstantRest})) {
            declaration = astNode.getParent().getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{grammar.annotationTypeElementDeclaration}));
        } else if (astNode.getParent().is(new AstNodeType[]{grammar.typeDeclaration})) {
            declaration = astNode.getParent();
        } else if (astNode.getParent().is(new AstNodeType[]{grammar.blockStatement})) {
            declaration = astNode.getParent();
        } else if (astNode.getParent().is(new AstNodeType[]{grammar.annotationTypeElementRest})) {
            declaration = astNode.getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{grammar.annotationTypeElementDeclaration}));
        } else {
            throw new IllegalStateException(astNode.getParent().getType().toString());
        }
        return declaration;
    }
}

