/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaGrammar implements GrammarRuleKey
{
    COMPILATION_UNIT,
    PACKAGE_DECLARATION,
    IMPORT_DECLARATION,
    TYPE_DECLARATION,
    ANNOTATION,
    QUALIFIED_IDENTIFIER,
    MODIFIER,
    CLASS_DECLARATION,
    ENUM_DECLARATION,
    INTERFACE_DECLARATION,
    ANNOTATION_TYPE_DECLARATION,
    TYPE_PARAMETERS,
    CLASS_TYPE,
    CLASS_TYPE_LIST,
    CLASS_BODY,
    CLASS_BODY_DECLARATION,
    CLASS_INIT_DECLARATION,
    BLOCK,
    MEMBER_DECL,
    FIELD_DECLARATION,
    GENERIC_METHOD_OR_CONSTRUCTOR_REST,
    TYPE,
    METHOD_DECLARATOR_REST,
    VARIABLE_DECLARATORS,
    VOID_METHOD_DECLARATOR_REST,
    CONSTRUCTOR_DECLARATOR_REST,
    FORMAL_PARAMETERS,
    DIM,
    METHOD_BODY,
    INTERFACE_BODY,
    INTERFACE_BODY_DECLARATION,
    INTERFACE_MEMBER_DECL,
    INTERFACE_METHOD_OR_FIELD_DECL,
    INTERFACE_GENERIC_METHOD_DECL,
    VOID_INTERFACE_METHOD_DECLARATORS_REST,
    INTERFACE_METHOD_OR_FIELD_REST,
    CONSTANT_DECLARATORS_REST,
    INTERFACE_METHOD_DECLARATOR_REST,
    CONSTANT_DECLARATOR_REST,
    CONSTANT_DECLARATOR,
    VARIABLE_INITIALIZER,
    ENUM_BODY,
    ENUM_CONSTANTS,
    ENUM_BODY_DECLARATIONS,
    ENUM_CONSTANT,
    ARGUMENTS,
    LOCAL_VARIABLE_DECLARATION_STATEMENT,
    VARIABLE_MODIFIERS,
    VARIABLE_DECLARATOR,
    FORMAL_PARAMETER,
    FORMAL_PARAMETER_DECLS,
    FORMAL_PARAMETERS_DECLS_REST,
    VARIABLE_DECLARATOR_ID,
    BLOCK_STATEMENTS,
    BLOCK_STATEMENT,
    STATEMENT,
    LABELED_STATEMENT,
    EXPRESSION_STATEMENT,
    IF_STATEMENT,
    WHILE_STATEMENT,
    FOR_STATEMENT,
    ASSERT_STATEMENT,
    SWITCH_STATEMENT,
    DO_STATEMENT,
    BREAK_STATEMENT,
    CONTINUE_STATEMENT,
    RETURN_STATEMENT,
    SYNCHRONIZED_STATEMENT,
    THROW_STATEMENT,
    EMPTY_STATEMENT,
    EXPRESSION,
    RESOURCE,
    PAR_EXPRESSION,
    FOR_INIT,
    FOR_UPDATE,
    CATCH_CLAUSE,
    CATCH_FORMAL_PARAMETER,
    CATCH_TYPE,
    FINALLY_,
    SWITCH_BLOCK_STATEMENT_GROUPS,
    STATEMENT_EXPRESSION,
    TRY_STATEMENT,
    TRY_WITH_RESOURCES_STATEMENT,
    RESOURCE_SPECIFICATION,
    SWITCH_BLOCK_STATEMENT_GROUP,
    SWITCH_LABEL,
    CONSTANT_EXPRESSION,
    ENUM_CONSTANT_NAME,
    BASIC_TYPE,
    REFERENCE_TYPE,
    TYPE_ARGUMENTS,
    TYPE_ARGUMENT,
    TYPE_PARAMETER,
    BOUND,
    CONDITIONAL_EXPRESSION,
    DEFAULT_VALUE,
    ANNOTATION_TYPE_BODY,
    ANNOTATION_TYPE_ELEMENT_DECLARATION,
    ANNOTATION_TYPE_ELEMENT_REST,
    ANNOTATION_METHOD_OR_CONSTANT_REST,
    ANNOTATION_METHOD_REST,
    ANNOTATION_CONSTANT_REST,
    ANNOTATION_REST,
    NORMAL_ANNOTATION_REST,
    ELEMENT_VALUE_PAIRS,
    ELEMENT_VALUE_PAIR,
    ELEMENT_VALUE,
    ELEMENT_VALUE_ARRAY_INITIALIZER,
    ELEMENT_VALUES,
    SINGLE_ELEMENT_ANNOTATION_REST,
    ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_OPERATOR,
    CONDITIONAL_OR_EXPRESSION,
    CONDITIONAL_AND_EXPRESSION,
    INCLUSIVE_OR_EXPRESSION,
    EXCLUSIVE_OR_EXPRESSION,
    AND_EXPRESSION,
    EQUALITY_EXPRESSION,
    RELATIONAL_EXPRESSION,
    SHIFT_EXPRESSION,
    ADDITIVE_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    UNARY_EXPRESSION,
    PREFIX_OP,
    PRIMARY,
    SELECTOR,
    POST_FIX_OP,
    NON_WILDCARD_TYPE_ARGUMENTS,
    EXPLICIT_GENERIC_INVOCATION_SUFFIX,
    SUPER_SUFFIX,
    LITERAL,
    CREATOR,
    IDENTIFIER_SUFFIX,
    EXPLICIT_GENERIC_INVOCATION,
    INNER_CREATOR,
    DIM_EXPR,
    CREATED_NAME,
    CLASS_CREATOR_REST,
    DIAMOND,
    ARRAY_CREATOR_REST,
    ARRAY_INITIALIZER,
    EOF,
    LETTER_OR_DIGIT,
    KEYWORD,
    SPACING;

    private static final String EXP_REGEXP = "(?:[Ee][+-]?+[0-9_]++)";
    private static final String BINARY_EXP_REGEXP = "(?:[Pp][+-]?+[0-9_]++)";
    private static final String FLOATING_LITERAL_WITHOUT_SUFFIX_REGEXP = "(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))";
    private static final String INTEGER_LITERAL_REGEXP = "(?:0[xX][0-9_a-fA-F]++|0[bB][01_]++|[0-9][0-9_]*+)";
    private final String internalName;

    public static LexerlessGrammar createGrammar() {
        return JavaGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        JavaGrammar.punctuators(b);
        JavaGrammar.keywords(b);
        JavaGrammar.compilationsUnits(b);
        JavaGrammar.classDeclaration(b);
        JavaGrammar.interfaceDeclarations(b);
        JavaGrammar.enums(b);
        JavaGrammar.formalParameters(b);
        JavaGrammar.blocksAndStatements(b);
        JavaGrammar.expressions(b);
        JavaGrammar.types(b);
        JavaGrammar.annotations(b);
        JavaGrammar.literals(b);
        b.setRootRule((GrammarRuleKey)COMPILATION_UNIT);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        JavaGrammar.punctuator(b, JavaPunctuator.AT, "@");
        JavaGrammar.punctuator(b, JavaPunctuator.AND, "&", b.nextNot(b.firstOf((Object)"=", (Object)"&")));
        JavaGrammar.punctuator(b, JavaPunctuator.ANDAND, "&&");
        JavaGrammar.punctuator(b, JavaPunctuator.ANDEQU, "&=");
        JavaGrammar.punctuator(b, JavaPunctuator.BANG, "!", b.nextNot((Object)"="));
        JavaGrammar.punctuator(b, JavaPunctuator.BSR, ">>>", b.nextNot((Object)"="));
        JavaGrammar.punctuator(b, JavaPunctuator.BSREQU, ">>>=");
        JavaGrammar.punctuator(b, JavaPunctuator.COLON, ":");
        JavaGrammar.punctuator(b, JavaPunctuator.COMMA, ",");
        JavaGrammar.punctuator(b, JavaPunctuator.DEC, "--");
        JavaGrammar.punctuator(b, JavaPunctuator.DIV, "/", b.nextNot((Object)"="));
        JavaGrammar.punctuator(b, JavaPunctuator.DIVEQU, "/=");
        JavaGrammar.punctuator(b, JavaPunctuator.DOT, ".");
        JavaGrammar.punctuator(b, JavaPunctuator.ELLIPSIS, "...");
        JavaGrammar.punctuator(b, JavaPunctuator.EQU, "=", b.nextNot((Object)"="));
        JavaGrammar.punctuator(b, JavaPunctuator.EQUAL, "==");
        JavaGrammar.punctuator(b, JavaPunctuator.GE, ">=");
        JavaGrammar.punctuator(b, JavaPunctuator.GT, ">", b.nextNot(b.firstOf((Object)"=", (Object)">")));
        JavaGrammar.punctuator(b, JavaPunctuator.HAT, "^", b.nextNot((Object)"="));
        JavaGrammar.punctuator(b, JavaPunctuator.HATEQU, "^=");
        JavaGrammar.punctuator(b, JavaPunctuator.INC, "++");
        JavaGrammar.punctuator(b, JavaPunctuator.LBRK, "[");
        JavaGrammar.punctuator(b, JavaPunctuator.LT, "<", b.nextNot(b.firstOf((Object)"=", (Object)"<")));
        JavaGrammar.punctuator(b, JavaPunctuator.LE, "<=");
        JavaGrammar.punctuator(b, JavaPunctuator.LPAR, "(");
        JavaGrammar.punctuator(b, JavaPunctuator.LWING, "{");
        JavaGrammar.punctuator(b, JavaPunctuator.MINUS, "-", b.nextNot(b.firstOf((Object)"-", (Object)"=")));
        JavaGrammar.punctuator(b, JavaPunctuator.MINUSEQU, "-=");
        JavaGrammar.punctuator(b, JavaPunctuator.MOD, "%", b.nextNot((Object)"="));
        JavaGrammar.punctuator(b, JavaPunctuator.MODEQU, "%=");
        JavaGrammar.punctuator(b, JavaPunctuator.NOTEQUAL, "!=");
        JavaGrammar.punctuator(b, JavaPunctuator.OR, "|", b.nextNot(b.firstOf((Object)"=", (Object)"|")));
        JavaGrammar.punctuator(b, JavaPunctuator.OREQU, "|=");
        JavaGrammar.punctuator(b, JavaPunctuator.OROR, "||");
        JavaGrammar.punctuator(b, JavaPunctuator.PLUS, "+", b.nextNot(b.firstOf((Object)"=", (Object)"+")));
        JavaGrammar.punctuator(b, JavaPunctuator.PLUSEQU, "+=");
        JavaGrammar.punctuator(b, JavaPunctuator.QUERY, "?");
        JavaGrammar.punctuator(b, JavaPunctuator.RBRK, "]");
        JavaGrammar.punctuator(b, JavaPunctuator.RPAR, ")");
        JavaGrammar.punctuator(b, JavaPunctuator.RWING, "}");
        JavaGrammar.punctuator(b, JavaPunctuator.SEMI, ";");
        JavaGrammar.punctuator(b, JavaPunctuator.SL, "<<", b.nextNot((Object)"="));
        JavaGrammar.punctuator(b, JavaPunctuator.SLEQU, "<<=");
        JavaGrammar.punctuator(b, JavaPunctuator.SR, ">>", b.nextNot(b.firstOf((Object)"=", (Object)">")));
        JavaGrammar.punctuator(b, JavaPunctuator.SREQU, ">>=");
        JavaGrammar.punctuator(b, JavaPunctuator.STAR, "*", b.nextNot((Object)"="));
        JavaGrammar.punctuator(b, JavaPunctuator.STAREQU, "*=");
        JavaGrammar.punctuator(b, JavaPunctuator.TILDA, "~");
        JavaGrammar.punctuator(b, JavaPunctuator.LPOINT, "<");
        JavaGrammar.punctuator(b, JavaPunctuator.RPOINT, ">");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        for (JavaKeyword tokenType : JavaKeyword.values()) {
            b.rule((GrammarRuleKey)tokenType).is((Object)tokenType.getValue(), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT), SPACING});
        }
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        b.rule(ruleKey).is((Object)value, new Object[]{SPACING});
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        b.rule(ruleKey).is((Object)value, new Object[]{element, SPACING});
    }

    private static void literals(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)SPACING).is(b.skippedTrivia(JavaGrammar.whitespace(b)), new Object[]{b.zeroOrMore(b.commentTrivia(b.firstOf(JavaGrammar.inlineComment(b), JavaGrammar.multilineComment(b))), new Object[]{b.skippedTrivia(JavaGrammar.whitespace(b))})}).skip();
        b.rule((GrammarRuleKey)EOF).is(b.token((TokenType)GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule((GrammarRuleKey)JavaTokenType.CHARACTER_LITERAL).is(JavaGrammar.characterLiteral(b), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.LITERAL).is(JavaGrammar.stringLiteral(b), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.FLOAT_LITERAL).is(b.regexp("(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))[fF]|[0-9][0-9_]*+[fF]"), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.DOUBLE_LITERAL).is(b.regexp("(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))[dD]?+|[0-9][0-9_]*+[dD]"), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.LONG_LITERAL).is(b.regexp("(?:0[xX][0-9_a-fA-F]++|0[bB][01_]++|[0-9][0-9_]*+)[lL]"), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.INTEGER_LITERAL).is(b.regexp(INTEGER_LITERAL_REGEXP), new Object[]{SPACING});
        b.rule((GrammarRuleKey)KEYWORD).is(b.firstOf((Object)"assert", (Object)"break", new Object[]{"case", "catch", "class", "const", "continue", "default", "do", "else", "enum", "extends", "finally", "final", "for", "goto", "if", "implements", "import", "interface", "instanceof", "new", "package", "return", "static", "super", "switch", "synchronized", "this", "throws", "throw", "try", "void", "while"}), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT)});
        b.rule((GrammarRuleKey)LETTER_OR_DIGIT).is(JavaGrammar.javaIdentifierPart(b));
        b.rule((GrammarRuleKey)JavaTokenType.IDENTIFIER).is(b.nextNot((Object)KEYWORD), new Object[]{JavaGrammar.javaIdentifier(b), SPACING});
        b.rule((GrammarRuleKey)LITERAL).is(b.firstOf((Object)JavaKeyword.TRUE, (Object)JavaKeyword.FALSE, new Object[]{JavaKeyword.NULL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.INTEGER_LITERAL}));
    }

    private static Object characterLiteral(LexerlessGrammarBuilder b) {
        return b.sequence(b.next((Object)"'"), b.regexp("'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'"));
    }

    private static Object stringLiteral(LexerlessGrammarBuilder b) {
        return b.sequence(b.next((Object)"\""), b.regexp("\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\""));
    }

    private static Object whitespace(LexerlessGrammarBuilder b) {
        return b.regexp("\\s*+");
    }

    private static Object inlineComment(LexerlessGrammarBuilder b) {
        return b.regexp("//[^\\n\\r]*+");
    }

    private static Object multilineComment(LexerlessGrammarBuilder b) {
        return b.regexp("/\\*[\\s\\S]*?\\*\\/");
    }

    private static Object javaIdentifier(LexerlessGrammarBuilder b) {
        return b.regexp("\\p{javaJavaIdentifierStart}++\\p{javaJavaIdentifierPart}*+");
    }

    private static Object javaIdentifierPart(LexerlessGrammarBuilder b) {
        return b.regexp("\\p{javaJavaIdentifierPart}");
    }

    private static void types(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)TYPE).is(b.firstOf((Object)BASIC_TYPE, (Object)CLASS_TYPE), new Object[]{b.zeroOrMore((Object)DIM)});
        b.rule((GrammarRuleKey)REFERENCE_TYPE).is(b.firstOf(b.sequence((Object)BASIC_TYPE, b.zeroOrMore((Object)DIM)), b.sequence((Object)CLASS_TYPE, b.zeroOrMore((Object)DIM))));
        b.rule((GrammarRuleKey)CLASS_TYPE).is((Object)JavaTokenType.IDENTIFIER, new Object[]{b.optional((Object)TYPE_ARGUMENTS), b.zeroOrMore((Object)JavaPunctuator.DOT, new Object[]{JavaTokenType.IDENTIFIER, b.optional((Object)TYPE_ARGUMENTS)})});
        b.rule((GrammarRuleKey)CLASS_TYPE_LIST).is((Object)CLASS_TYPE, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{CLASS_TYPE})});
        b.rule((GrammarRuleKey)TYPE_ARGUMENTS).is((Object)JavaPunctuator.LPOINT, new Object[]{TYPE_ARGUMENT, b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{TYPE_ARGUMENT}), JavaPunctuator.RPOINT});
        b.rule((GrammarRuleKey)TYPE_ARGUMENT).is(b.firstOf((Object)REFERENCE_TYPE, b.sequence((Object)JavaPunctuator.QUERY, b.optional(b.firstOf((Object)JavaKeyword.EXTENDS, (Object)JavaKeyword.SUPER), new Object[]{REFERENCE_TYPE}))));
        b.rule((GrammarRuleKey)TYPE_PARAMETERS).is((Object)JavaPunctuator.LPOINT, new Object[]{TYPE_PARAMETER, b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{TYPE_PARAMETER}), JavaPunctuator.RPOINT});
        b.rule((GrammarRuleKey)TYPE_PARAMETER).is((Object)JavaTokenType.IDENTIFIER, new Object[]{b.optional((Object)JavaKeyword.EXTENDS, new Object[]{BOUND})});
        b.rule((GrammarRuleKey)BOUND).is((Object)CLASS_TYPE, new Object[]{b.zeroOrMore((Object)JavaPunctuator.AND, new Object[]{CLASS_TYPE})});
        b.rule((GrammarRuleKey)MODIFIER).is(b.firstOf((Object)ANNOTATION, (Object)JavaKeyword.PUBLIC, new Object[]{JavaKeyword.PROTECTED, JavaKeyword.PRIVATE, JavaKeyword.STATIC, JavaKeyword.ABSTRACT, JavaKeyword.FINAL, JavaKeyword.NATIVE, JavaKeyword.SYNCHRONIZED, JavaKeyword.TRANSIENT, JavaKeyword.VOLATILE, JavaKeyword.STRICTFP}));
    }

    private static void compilationsUnits(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)COMPILATION_UNIT).is((Object)SPACING, new Object[]{b.optional((Object)PACKAGE_DECLARATION), b.zeroOrMore((Object)IMPORT_DECLARATION), b.zeroOrMore((Object)TYPE_DECLARATION), EOF});
        b.rule((GrammarRuleKey)PACKAGE_DECLARATION).is(b.zeroOrMore((Object)ANNOTATION), new Object[]{JavaKeyword.PACKAGE, QUALIFIED_IDENTIFIER, JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)IMPORT_DECLARATION).is((Object)JavaKeyword.IMPORT, new Object[]{b.optional((Object)JavaKeyword.STATIC), QUALIFIED_IDENTIFIER, b.optional((Object)JavaPunctuator.DOT, new Object[]{JavaPunctuator.STAR}), JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)TYPE_DECLARATION).is(b.firstOf(b.sequence(b.zeroOrMore((Object)MODIFIER), b.firstOf((Object)CLASS_DECLARATION, (Object)ENUM_DECLARATION, new Object[]{INTERFACE_DECLARATION, ANNOTATION_TYPE_DECLARATION})), (Object)JavaPunctuator.SEMI));
    }

    private static void classDeclaration(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)CLASS_DECLARATION).is((Object)JavaKeyword.CLASS, new Object[]{JavaTokenType.IDENTIFIER, b.optional((Object)TYPE_PARAMETERS), b.optional((Object)JavaKeyword.EXTENDS, new Object[]{CLASS_TYPE}), b.optional((Object)JavaKeyword.IMPLEMENTS, new Object[]{CLASS_TYPE_LIST}), CLASS_BODY});
        b.rule((GrammarRuleKey)CLASS_BODY).is((Object)JavaPunctuator.LWING, new Object[]{b.zeroOrMore((Object)CLASS_BODY_DECLARATION), JavaPunctuator.RWING});
        b.rule((GrammarRuleKey)CLASS_BODY_DECLARATION).is(b.firstOf((Object)JavaPunctuator.SEMI, (Object)CLASS_INIT_DECLARATION, new Object[]{b.sequence(b.zeroOrMore((Object)MODIFIER), (Object)MEMBER_DECL)}));
        b.rule((GrammarRuleKey)CLASS_INIT_DECLARATION).is(b.optional((Object)JavaKeyword.STATIC), new Object[]{BLOCK});
        b.rule((GrammarRuleKey)MEMBER_DECL).is(b.firstOf(b.sequence((Object)TYPE_PARAMETERS, (Object)GENERIC_METHOD_OR_CONSTRUCTOR_REST), b.sequence((Object)TYPE, (Object)JavaTokenType.IDENTIFIER, new Object[]{METHOD_DECLARATOR_REST}), new Object[]{FIELD_DECLARATION, b.sequence((Object)JavaKeyword.VOID, (Object)JavaTokenType.IDENTIFIER, new Object[]{VOID_METHOD_DECLARATOR_REST}), b.sequence((Object)JavaTokenType.IDENTIFIER, (Object)CONSTRUCTOR_DECLARATOR_REST), INTERFACE_DECLARATION, CLASS_DECLARATION, ENUM_DECLARATION, ANNOTATION_TYPE_DECLARATION}));
        b.rule((GrammarRuleKey)FIELD_DECLARATION).is((Object)TYPE, new Object[]{VARIABLE_DECLARATORS, JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)GENERIC_METHOD_OR_CONSTRUCTOR_REST).is(b.firstOf(b.sequence(b.firstOf((Object)TYPE, (Object)JavaKeyword.VOID), (Object)JavaTokenType.IDENTIFIER, new Object[]{METHOD_DECLARATOR_REST}), b.sequence((Object)JavaTokenType.IDENTIFIER, (Object)CONSTRUCTOR_DECLARATOR_REST)));
        b.rule((GrammarRuleKey)METHOD_DECLARATOR_REST).is((Object)FORMAL_PARAMETERS, new Object[]{b.zeroOrMore((Object)DIM), b.optional((Object)JavaKeyword.THROWS, new Object[]{CLASS_TYPE_LIST}), b.firstOf((Object)METHOD_BODY, (Object)JavaPunctuator.SEMI)});
        b.rule((GrammarRuleKey)VOID_METHOD_DECLARATOR_REST).is((Object)FORMAL_PARAMETERS, new Object[]{b.optional((Object)JavaKeyword.THROWS, new Object[]{CLASS_TYPE_LIST}), b.firstOf((Object)METHOD_BODY, (Object)JavaPunctuator.SEMI)});
        b.rule((GrammarRuleKey)CONSTRUCTOR_DECLARATOR_REST).is((Object)FORMAL_PARAMETERS, new Object[]{b.optional((Object)JavaKeyword.THROWS, new Object[]{CLASS_TYPE_LIST}), METHOD_BODY});
        b.rule((GrammarRuleKey)METHOD_BODY).is((Object)BLOCK);
    }

    private static void enums(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)ENUM_DECLARATION).is((Object)JavaKeyword.ENUM, new Object[]{JavaTokenType.IDENTIFIER, b.optional((Object)JavaKeyword.IMPLEMENTS, new Object[]{CLASS_TYPE_LIST}), ENUM_BODY});
        b.rule((GrammarRuleKey)ENUM_BODY).is((Object)JavaPunctuator.LWING, new Object[]{b.optional((Object)ENUM_CONSTANTS), b.optional((Object)JavaPunctuator.COMMA), b.optional((Object)ENUM_BODY_DECLARATIONS), JavaPunctuator.RWING});
        b.rule((GrammarRuleKey)ENUM_CONSTANTS).is((Object)ENUM_CONSTANT, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{ENUM_CONSTANT})});
        b.rule((GrammarRuleKey)ENUM_CONSTANT).is(b.zeroOrMore((Object)ANNOTATION), new Object[]{JavaTokenType.IDENTIFIER, b.optional((Object)ARGUMENTS), b.optional((Object)CLASS_BODY)});
        b.rule((GrammarRuleKey)ENUM_BODY_DECLARATIONS).is((Object)JavaPunctuator.SEMI, new Object[]{b.zeroOrMore((Object)CLASS_BODY_DECLARATION)});
    }

    private static void interfaceDeclarations(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)INTERFACE_DECLARATION).is((Object)JavaKeyword.INTERFACE, new Object[]{JavaTokenType.IDENTIFIER, b.optional((Object)TYPE_PARAMETERS), b.optional((Object)JavaKeyword.EXTENDS, new Object[]{CLASS_TYPE_LIST}), INTERFACE_BODY});
        b.rule((GrammarRuleKey)INTERFACE_BODY).is((Object)JavaPunctuator.LWING, new Object[]{b.zeroOrMore((Object)INTERFACE_BODY_DECLARATION), JavaPunctuator.RWING});
        b.rule((GrammarRuleKey)INTERFACE_BODY_DECLARATION).is(b.firstOf(b.sequence(b.zeroOrMore((Object)MODIFIER), (Object)INTERFACE_MEMBER_DECL), (Object)JavaPunctuator.SEMI));
        b.rule((GrammarRuleKey)INTERFACE_MEMBER_DECL).is(b.firstOf((Object)INTERFACE_METHOD_OR_FIELD_DECL, (Object)INTERFACE_GENERIC_METHOD_DECL, new Object[]{b.sequence((Object)JavaKeyword.VOID, (Object)JavaTokenType.IDENTIFIER, new Object[]{VOID_INTERFACE_METHOD_DECLARATORS_REST}), INTERFACE_DECLARATION, ANNOTATION_TYPE_DECLARATION, CLASS_DECLARATION, ENUM_DECLARATION}));
        b.rule((GrammarRuleKey)INTERFACE_METHOD_OR_FIELD_DECL).is((Object)TYPE, new Object[]{JavaTokenType.IDENTIFIER, INTERFACE_METHOD_OR_FIELD_REST});
        b.rule((GrammarRuleKey)INTERFACE_METHOD_OR_FIELD_REST).is(b.firstOf(b.sequence((Object)CONSTANT_DECLARATORS_REST, (Object)JavaPunctuator.SEMI), (Object)INTERFACE_METHOD_DECLARATOR_REST));
        b.rule((GrammarRuleKey)INTERFACE_METHOD_DECLARATOR_REST).is((Object)FORMAL_PARAMETERS, new Object[]{b.zeroOrMore((Object)DIM), b.optional((Object)JavaKeyword.THROWS, new Object[]{CLASS_TYPE_LIST}), JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)INTERFACE_GENERIC_METHOD_DECL).is((Object)TYPE_PARAMETERS, new Object[]{b.firstOf((Object)TYPE, (Object)JavaKeyword.VOID), JavaTokenType.IDENTIFIER, INTERFACE_METHOD_DECLARATOR_REST});
        b.rule((GrammarRuleKey)VOID_INTERFACE_METHOD_DECLARATORS_REST).is((Object)FORMAL_PARAMETERS, new Object[]{b.optional((Object)JavaKeyword.THROWS, new Object[]{CLASS_TYPE_LIST}), JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)CONSTANT_DECLARATORS_REST).is((Object)CONSTANT_DECLARATOR_REST, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{CONSTANT_DECLARATOR})});
        b.rule((GrammarRuleKey)CONSTANT_DECLARATOR).is((Object)JavaTokenType.IDENTIFIER, new Object[]{CONSTANT_DECLARATOR_REST});
        b.rule((GrammarRuleKey)CONSTANT_DECLARATOR_REST).is(b.zeroOrMore((Object)DIM), new Object[]{JavaPunctuator.EQU, VARIABLE_INITIALIZER});
    }

    private static void formalParameters(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)FORMAL_PARAMETERS).is((Object)JavaPunctuator.LPAR, new Object[]{b.optional((Object)FORMAL_PARAMETER_DECLS), JavaPunctuator.RPAR});
        b.rule((GrammarRuleKey)FORMAL_PARAMETER).is(b.zeroOrMore(b.firstOf((Object)JavaKeyword.FINAL, (Object)ANNOTATION)), new Object[]{TYPE, VARIABLE_DECLARATOR_ID});
        b.rule((GrammarRuleKey)FORMAL_PARAMETER_DECLS).is(b.zeroOrMore(b.firstOf((Object)JavaKeyword.FINAL, (Object)ANNOTATION)), new Object[]{TYPE, FORMAL_PARAMETERS_DECLS_REST});
        b.rule((GrammarRuleKey)FORMAL_PARAMETERS_DECLS_REST).is(b.firstOf(b.sequence((Object)VARIABLE_DECLARATOR_ID, b.optional((Object)JavaPunctuator.COMMA, new Object[]{FORMAL_PARAMETER_DECLS})), b.sequence((Object)JavaPunctuator.ELLIPSIS, (Object)VARIABLE_DECLARATOR_ID)));
        b.rule((GrammarRuleKey)VARIABLE_DECLARATOR_ID).is((Object)JavaTokenType.IDENTIFIER, new Object[]{b.zeroOrMore((Object)DIM)});
    }

    private static void annotations(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)ANNOTATION_TYPE_DECLARATION).is((Object)JavaPunctuator.AT, new Object[]{JavaKeyword.INTERFACE, JavaTokenType.IDENTIFIER, ANNOTATION_TYPE_BODY});
        b.rule((GrammarRuleKey)ANNOTATION_TYPE_BODY).is((Object)JavaPunctuator.LWING, new Object[]{b.zeroOrMore((Object)ANNOTATION_TYPE_ELEMENT_DECLARATION), JavaPunctuator.RWING});
        b.rule((GrammarRuleKey)ANNOTATION_TYPE_ELEMENT_DECLARATION).is(b.firstOf(b.sequence(b.zeroOrMore((Object)MODIFIER), (Object)ANNOTATION_TYPE_ELEMENT_REST), (Object)JavaPunctuator.SEMI));
        b.rule((GrammarRuleKey)ANNOTATION_TYPE_ELEMENT_REST).is(b.firstOf(b.sequence((Object)TYPE, (Object)ANNOTATION_METHOD_OR_CONSTANT_REST, new Object[]{JavaPunctuator.SEMI}), (Object)CLASS_DECLARATION, new Object[]{ENUM_DECLARATION, INTERFACE_DECLARATION, ANNOTATION_TYPE_DECLARATION}));
        b.rule((GrammarRuleKey)ANNOTATION_METHOD_OR_CONSTANT_REST).is(b.firstOf((Object)ANNOTATION_METHOD_REST, (Object)ANNOTATION_CONSTANT_REST));
        b.rule((GrammarRuleKey)ANNOTATION_METHOD_REST).is((Object)JavaTokenType.IDENTIFIER, new Object[]{JavaPunctuator.LPAR, JavaPunctuator.RPAR, b.optional((Object)DEFAULT_VALUE)});
        b.rule((GrammarRuleKey)ANNOTATION_CONSTANT_REST).is((Object)VARIABLE_DECLARATORS);
        b.rule((GrammarRuleKey)DEFAULT_VALUE).is((Object)JavaKeyword.DEFAULT, new Object[]{ELEMENT_VALUE});
        b.rule((GrammarRuleKey)ANNOTATION).is((Object)JavaPunctuator.AT, new Object[]{QUALIFIED_IDENTIFIER, b.optional((Object)ANNOTATION_REST)});
        b.rule((GrammarRuleKey)ANNOTATION_REST).is(b.firstOf((Object)NORMAL_ANNOTATION_REST, (Object)SINGLE_ELEMENT_ANNOTATION_REST));
        b.rule((GrammarRuleKey)NORMAL_ANNOTATION_REST).is((Object)JavaPunctuator.LPAR, new Object[]{b.optional((Object)ELEMENT_VALUE_PAIRS), JavaPunctuator.RPAR});
        b.rule((GrammarRuleKey)ELEMENT_VALUE_PAIRS).is((Object)ELEMENT_VALUE_PAIR, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{ELEMENT_VALUE_PAIR})});
        b.rule((GrammarRuleKey)ELEMENT_VALUE_PAIR).is((Object)JavaTokenType.IDENTIFIER, new Object[]{JavaPunctuator.EQU, ELEMENT_VALUE});
        b.rule((GrammarRuleKey)ELEMENT_VALUE).is(b.firstOf((Object)CONDITIONAL_EXPRESSION, (Object)ANNOTATION, new Object[]{ELEMENT_VALUE_ARRAY_INITIALIZER}));
        b.rule((GrammarRuleKey)ELEMENT_VALUE_ARRAY_INITIALIZER).is((Object)JavaPunctuator.LWING, new Object[]{b.optional((Object)ELEMENT_VALUES), b.optional((Object)JavaPunctuator.COMMA), JavaPunctuator.RWING});
        b.rule((GrammarRuleKey)ELEMENT_VALUES).is((Object)ELEMENT_VALUE, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{ELEMENT_VALUE})});
        b.rule((GrammarRuleKey)SINGLE_ELEMENT_ANNOTATION_REST).is((Object)JavaPunctuator.LPAR, new Object[]{ELEMENT_VALUE, JavaPunctuator.RPAR});
    }

    private static void blocksAndStatements(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)BLOCK).is((Object)JavaPunctuator.LWING, new Object[]{BLOCK_STATEMENTS, JavaPunctuator.RWING});
        b.rule((GrammarRuleKey)BLOCK_STATEMENTS).is(b.zeroOrMore((Object)BLOCK_STATEMENT));
        b.rule((GrammarRuleKey)BLOCK_STATEMENT).is(b.firstOf((Object)LOCAL_VARIABLE_DECLARATION_STATEMENT, b.sequence(b.zeroOrMore((Object)MODIFIER), b.firstOf((Object)CLASS_DECLARATION, (Object)ENUM_DECLARATION)), new Object[]{STATEMENT}));
        b.rule((GrammarRuleKey)LOCAL_VARIABLE_DECLARATION_STATEMENT).is((Object)VARIABLE_MODIFIERS, new Object[]{TYPE, VARIABLE_DECLARATORS, JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)VARIABLE_MODIFIERS).is(b.zeroOrMore(b.firstOf((Object)ANNOTATION, (Object)JavaKeyword.FINAL)));
        b.rule((GrammarRuleKey)VARIABLE_DECLARATORS).is((Object)VARIABLE_DECLARATOR, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{VARIABLE_DECLARATOR})});
        b.rule((GrammarRuleKey)VARIABLE_DECLARATOR).is((Object)JavaTokenType.IDENTIFIER, new Object[]{b.zeroOrMore((Object)DIM), b.optional((Object)JavaPunctuator.EQU, new Object[]{VARIABLE_INITIALIZER})});
        b.rule((GrammarRuleKey)STATEMENT).is(b.firstOf((Object)BLOCK, (Object)ASSERT_STATEMENT, new Object[]{IF_STATEMENT, FOR_STATEMENT, WHILE_STATEMENT, DO_STATEMENT, TRY_STATEMENT, SWITCH_STATEMENT, SYNCHRONIZED_STATEMENT, RETURN_STATEMENT, THROW_STATEMENT, BREAK_STATEMENT, CONTINUE_STATEMENT, LABELED_STATEMENT, EXPRESSION_STATEMENT, EMPTY_STATEMENT}));
        b.rule((GrammarRuleKey)EMPTY_STATEMENT).is((Object)JavaPunctuator.SEMI);
        b.rule((GrammarRuleKey)LABELED_STATEMENT).is((Object)JavaTokenType.IDENTIFIER, new Object[]{JavaPunctuator.COLON, STATEMENT});
        b.rule((GrammarRuleKey)EXPRESSION_STATEMENT).is((Object)STATEMENT_EXPRESSION, new Object[]{JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)IF_STATEMENT).is((Object)JavaKeyword.IF, new Object[]{PAR_EXPRESSION, STATEMENT, b.optional((Object)JavaKeyword.ELSE, new Object[]{STATEMENT})});
        b.rule((GrammarRuleKey)ASSERT_STATEMENT).is((Object)JavaKeyword.ASSERT, new Object[]{EXPRESSION, b.optional((Object)JavaPunctuator.COLON, new Object[]{EXPRESSION}), JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)SWITCH_STATEMENT).is((Object)JavaKeyword.SWITCH, new Object[]{PAR_EXPRESSION, JavaPunctuator.LWING, SWITCH_BLOCK_STATEMENT_GROUPS, JavaPunctuator.RWING});
        b.rule((GrammarRuleKey)SWITCH_BLOCK_STATEMENT_GROUPS).is(b.zeroOrMore((Object)SWITCH_BLOCK_STATEMENT_GROUP));
        b.rule((GrammarRuleKey)SWITCH_BLOCK_STATEMENT_GROUP).is((Object)SWITCH_LABEL, new Object[]{BLOCK_STATEMENTS});
        b.rule((GrammarRuleKey)SWITCH_LABEL).is(b.firstOf(b.sequence((Object)JavaKeyword.CASE, (Object)CONSTANT_EXPRESSION, new Object[]{JavaPunctuator.COLON}), b.sequence((Object)JavaKeyword.CASE, (Object)ENUM_CONSTANT_NAME, new Object[]{JavaPunctuator.COLON}), new Object[]{b.sequence((Object)JavaKeyword.DEFAULT, (Object)JavaPunctuator.COLON)}));
        b.rule((GrammarRuleKey)ENUM_CONSTANT_NAME).is((Object)JavaTokenType.IDENTIFIER);
        b.rule((GrammarRuleKey)WHILE_STATEMENT).is((Object)JavaKeyword.WHILE, new Object[]{PAR_EXPRESSION, STATEMENT});
        b.rule((GrammarRuleKey)DO_STATEMENT).is((Object)JavaKeyword.DO, new Object[]{STATEMENT, JavaKeyword.WHILE, PAR_EXPRESSION, JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)FOR_STATEMENT).is(b.firstOf(b.sequence((Object)JavaKeyword.FOR, (Object)JavaPunctuator.LPAR, new Object[]{b.optional((Object)FOR_INIT), JavaPunctuator.SEMI, b.optional((Object)EXPRESSION), JavaPunctuator.SEMI, b.optional((Object)FOR_UPDATE), JavaPunctuator.RPAR, STATEMENT}), b.sequence((Object)JavaKeyword.FOR, (Object)JavaPunctuator.LPAR, new Object[]{FORMAL_PARAMETER, JavaPunctuator.COLON, EXPRESSION, JavaPunctuator.RPAR, STATEMENT})));
        b.rule((GrammarRuleKey)FOR_INIT).is(b.firstOf(b.sequence(b.zeroOrMore(b.firstOf((Object)JavaKeyword.FINAL, (Object)ANNOTATION)), (Object)TYPE, new Object[]{VARIABLE_DECLARATORS}), b.sequence((Object)STATEMENT_EXPRESSION, b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{STATEMENT_EXPRESSION}))));
        b.rule((GrammarRuleKey)FOR_UPDATE).is((Object)STATEMENT_EXPRESSION, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{STATEMENT_EXPRESSION})});
        b.rule((GrammarRuleKey)BREAK_STATEMENT).is((Object)JavaKeyword.BREAK, new Object[]{b.optional((Object)JavaTokenType.IDENTIFIER), JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)CONTINUE_STATEMENT).is((Object)JavaKeyword.CONTINUE, new Object[]{b.optional((Object)JavaTokenType.IDENTIFIER), JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)RETURN_STATEMENT).is((Object)JavaKeyword.RETURN, new Object[]{b.optional((Object)EXPRESSION), JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)THROW_STATEMENT).is((Object)JavaKeyword.THROW, new Object[]{EXPRESSION, JavaPunctuator.SEMI});
        b.rule((GrammarRuleKey)SYNCHRONIZED_STATEMENT).is((Object)JavaKeyword.SYNCHRONIZED, new Object[]{PAR_EXPRESSION, BLOCK});
        b.rule((GrammarRuleKey)TRY_STATEMENT).is(b.firstOf(b.sequence((Object)JavaKeyword.TRY, (Object)BLOCK, new Object[]{b.firstOf(b.sequence(b.oneOrMore((Object)CATCH_CLAUSE), b.optional((Object)FINALLY_)), (Object)FINALLY_)}), (Object)TRY_WITH_RESOURCES_STATEMENT));
        b.rule((GrammarRuleKey)TRY_WITH_RESOURCES_STATEMENT).is((Object)JavaKeyword.TRY, new Object[]{RESOURCE_SPECIFICATION, BLOCK, b.zeroOrMore((Object)CATCH_CLAUSE), b.optional((Object)FINALLY_)});
        b.rule((GrammarRuleKey)RESOURCE_SPECIFICATION).is((Object)JavaPunctuator.LPAR, new Object[]{RESOURCE, b.zeroOrMore((Object)JavaPunctuator.SEMI, new Object[]{RESOURCE}), b.optional((Object)JavaPunctuator.SEMI), JavaPunctuator.RPAR});
        b.rule((GrammarRuleKey)RESOURCE).is(b.optional((Object)VARIABLE_MODIFIERS), new Object[]{TYPE, VARIABLE_DECLARATOR_ID, JavaPunctuator.EQU, EXPRESSION});
        b.rule((GrammarRuleKey)CATCH_CLAUSE).is((Object)JavaKeyword.CATCH, new Object[]{JavaPunctuator.LPAR, CATCH_FORMAL_PARAMETER, JavaPunctuator.RPAR, BLOCK});
        b.rule((GrammarRuleKey)CATCH_FORMAL_PARAMETER).is(b.optional((Object)VARIABLE_MODIFIERS), new Object[]{CATCH_TYPE, VARIABLE_DECLARATOR_ID});
        b.rule((GrammarRuleKey)CATCH_TYPE).is((Object)CLASS_TYPE, new Object[]{b.zeroOrMore((Object)JavaPunctuator.OR, new Object[]{CLASS_TYPE})});
        b.rule((GrammarRuleKey)FINALLY_).is((Object)JavaKeyword.FINALLY, new Object[]{BLOCK});
    }

    private static void expressions(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)STATEMENT_EXPRESSION).is((Object)EXPRESSION);
        b.rule((GrammarRuleKey)CONSTANT_EXPRESSION).is((Object)EXPRESSION);
        b.rule((GrammarRuleKey)EXPRESSION).is((Object)ASSIGNMENT_EXPRESSION);
        b.rule((GrammarRuleKey)ASSIGNMENT_EXPRESSION).is((Object)CONDITIONAL_EXPRESSION, new Object[]{b.zeroOrMore((Object)ASSIGNMENT_OPERATOR, new Object[]{CONDITIONAL_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)ASSIGNMENT_OPERATOR).is(b.firstOf((Object)JavaPunctuator.EQU, (Object)JavaPunctuator.PLUSEQU, new Object[]{JavaPunctuator.MINUSEQU, JavaPunctuator.STAREQU, JavaPunctuator.DIVEQU, JavaPunctuator.ANDEQU, JavaPunctuator.OREQU, JavaPunctuator.HATEQU, JavaPunctuator.MODEQU, JavaPunctuator.SLEQU, JavaPunctuator.SREQU, JavaPunctuator.BSREQU}));
        b.rule((GrammarRuleKey)CONDITIONAL_EXPRESSION).is((Object)CONDITIONAL_OR_EXPRESSION, new Object[]{b.zeroOrMore((Object)JavaPunctuator.QUERY, new Object[]{EXPRESSION, JavaPunctuator.COLON, CONDITIONAL_OR_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)CONDITIONAL_OR_EXPRESSION).is((Object)CONDITIONAL_AND_EXPRESSION, new Object[]{b.zeroOrMore((Object)JavaPunctuator.OROR, new Object[]{CONDITIONAL_AND_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)CONDITIONAL_AND_EXPRESSION).is((Object)INCLUSIVE_OR_EXPRESSION, new Object[]{b.zeroOrMore((Object)JavaPunctuator.ANDAND, new Object[]{INCLUSIVE_OR_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)INCLUSIVE_OR_EXPRESSION).is((Object)EXCLUSIVE_OR_EXPRESSION, new Object[]{b.zeroOrMore((Object)JavaPunctuator.OR, new Object[]{EXCLUSIVE_OR_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)EXCLUSIVE_OR_EXPRESSION).is((Object)AND_EXPRESSION, new Object[]{b.zeroOrMore((Object)JavaPunctuator.HAT, new Object[]{AND_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)AND_EXPRESSION).is((Object)EQUALITY_EXPRESSION, new Object[]{b.zeroOrMore((Object)JavaPunctuator.AND, new Object[]{EQUALITY_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)EQUALITY_EXPRESSION).is((Object)RELATIONAL_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)JavaPunctuator.EQUAL, (Object)JavaPunctuator.NOTEQUAL), new Object[]{RELATIONAL_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)RELATIONAL_EXPRESSION).is((Object)SHIFT_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf(b.sequence(b.firstOf((Object)JavaPunctuator.GE, (Object)JavaPunctuator.GT, new Object[]{JavaPunctuator.LE, JavaPunctuator.LT}), (Object)SHIFT_EXPRESSION), b.sequence((Object)JavaKeyword.INSTANCEOF, (Object)REFERENCE_TYPE)))}).skipIfOneChild();
        b.rule((GrammarRuleKey)SHIFT_EXPRESSION).is((Object)ADDITIVE_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)JavaPunctuator.SL, (Object)JavaPunctuator.BSR, new Object[]{JavaPunctuator.SR}), new Object[]{ADDITIVE_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)ADDITIVE_EXPRESSION).is((Object)MULTIPLICATIVE_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)JavaPunctuator.PLUS, (Object)JavaPunctuator.MINUS), new Object[]{MULTIPLICATIVE_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)MULTIPLICATIVE_EXPRESSION).is((Object)UNARY_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)JavaPunctuator.STAR, (Object)JavaPunctuator.DIV, new Object[]{JavaPunctuator.MOD}), new Object[]{UNARY_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)UNARY_EXPRESSION).is(b.firstOf(b.sequence((Object)PREFIX_OP, (Object)UNARY_EXPRESSION), b.sequence((Object)JavaPunctuator.LPAR, (Object)TYPE, new Object[]{JavaPunctuator.RPAR, UNARY_EXPRESSION}), new Object[]{b.sequence((Object)PRIMARY, b.zeroOrMore((Object)SELECTOR), new Object[]{b.zeroOrMore((Object)POST_FIX_OP)})})).skipIfOneChild();
        b.rule((GrammarRuleKey)PRIMARY).is(b.firstOf((Object)PAR_EXPRESSION, b.sequence((Object)NON_WILDCARD_TYPE_ARGUMENTS, b.firstOf((Object)EXPLICIT_GENERIC_INVOCATION_SUFFIX, b.sequence((Object)JavaKeyword.THIS, (Object)ARGUMENTS))), new Object[]{b.sequence((Object)JavaKeyword.THIS, b.optional((Object)ARGUMENTS)), b.sequence((Object)JavaKeyword.SUPER, (Object)SUPER_SUFFIX), LITERAL, b.sequence((Object)JavaKeyword.NEW, (Object)CREATOR), b.sequence((Object)QUALIFIED_IDENTIFIER, b.optional((Object)IDENTIFIER_SUFFIX)), b.sequence((Object)BASIC_TYPE, b.zeroOrMore((Object)DIM), new Object[]{JavaPunctuator.DOT, JavaKeyword.CLASS}), b.sequence((Object)JavaKeyword.VOID, (Object)JavaPunctuator.DOT, new Object[]{JavaKeyword.CLASS})}));
        b.rule((GrammarRuleKey)IDENTIFIER_SUFFIX).is(b.firstOf(b.sequence((Object)JavaPunctuator.LBRK, b.firstOf(b.sequence((Object)JavaPunctuator.RBRK, b.zeroOrMore((Object)DIM), new Object[]{JavaPunctuator.DOT, JavaKeyword.CLASS}), b.sequence((Object)EXPRESSION, (Object)JavaPunctuator.RBRK))), (Object)ARGUMENTS, new Object[]{b.sequence((Object)JavaPunctuator.DOT, b.firstOf((Object)JavaKeyword.CLASS, (Object)EXPLICIT_GENERIC_INVOCATION, new Object[]{JavaKeyword.THIS, b.sequence((Object)JavaKeyword.SUPER, (Object)ARGUMENTS), b.sequence((Object)JavaKeyword.NEW, b.optional((Object)NON_WILDCARD_TYPE_ARGUMENTS), new Object[]{INNER_CREATOR})}))}));
        b.rule((GrammarRuleKey)EXPLICIT_GENERIC_INVOCATION).is((Object)NON_WILDCARD_TYPE_ARGUMENTS, new Object[]{EXPLICIT_GENERIC_INVOCATION_SUFFIX});
        b.rule((GrammarRuleKey)NON_WILDCARD_TYPE_ARGUMENTS).is((Object)JavaPunctuator.LPOINT, new Object[]{REFERENCE_TYPE, b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{REFERENCE_TYPE}), JavaPunctuator.RPOINT});
        b.rule((GrammarRuleKey)EXPLICIT_GENERIC_INVOCATION_SUFFIX).is(b.firstOf(b.sequence((Object)JavaKeyword.SUPER, (Object)SUPER_SUFFIX), b.sequence((Object)JavaTokenType.IDENTIFIER, (Object)ARGUMENTS)));
        b.rule((GrammarRuleKey)PREFIX_OP).is(b.firstOf((Object)JavaPunctuator.INC, (Object)JavaPunctuator.DEC, new Object[]{JavaPunctuator.BANG, JavaPunctuator.TILDA, JavaPunctuator.PLUS, JavaPunctuator.MINUS}));
        b.rule((GrammarRuleKey)POST_FIX_OP).is(b.firstOf((Object)JavaPunctuator.INC, (Object)JavaPunctuator.DEC));
        b.rule((GrammarRuleKey)SELECTOR).is(b.firstOf(b.sequence((Object)JavaPunctuator.DOT, (Object)JavaTokenType.IDENTIFIER, new Object[]{b.optional((Object)ARGUMENTS)}), b.sequence((Object)JavaPunctuator.DOT, (Object)EXPLICIT_GENERIC_INVOCATION), new Object[]{b.sequence((Object)JavaPunctuator.DOT, (Object)JavaKeyword.THIS), b.sequence((Object)JavaPunctuator.DOT, (Object)JavaKeyword.SUPER, new Object[]{SUPER_SUFFIX}), b.sequence((Object)JavaPunctuator.DOT, (Object)JavaKeyword.NEW, new Object[]{b.optional((Object)NON_WILDCARD_TYPE_ARGUMENTS), INNER_CREATOR}), DIM_EXPR}));
        b.rule((GrammarRuleKey)SUPER_SUFFIX).is(b.firstOf((Object)ARGUMENTS, b.sequence((Object)JavaPunctuator.DOT, (Object)JavaTokenType.IDENTIFIER, new Object[]{b.optional((Object)ARGUMENTS)})));
        b.rule((GrammarRuleKey)BASIC_TYPE).is(b.firstOf((Object)JavaKeyword.BYTE, (Object)JavaKeyword.SHORT, new Object[]{JavaKeyword.CHAR, JavaKeyword.INT, JavaKeyword.LONG, JavaKeyword.FLOAT, JavaKeyword.DOUBLE, JavaKeyword.BOOLEAN}));
        b.rule((GrammarRuleKey)ARGUMENTS).is((Object)JavaPunctuator.LPAR, new Object[]{b.optional((Object)EXPRESSION, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{EXPRESSION})}), JavaPunctuator.RPAR});
        b.rule((GrammarRuleKey)CREATOR).is(b.firstOf(b.sequence(b.optional((Object)NON_WILDCARD_TYPE_ARGUMENTS), (Object)CREATED_NAME, new Object[]{CLASS_CREATOR_REST}), b.sequence(b.optional((Object)NON_WILDCARD_TYPE_ARGUMENTS), b.firstOf((Object)CLASS_TYPE, (Object)BASIC_TYPE), new Object[]{ARRAY_CREATOR_REST})));
        b.rule((GrammarRuleKey)CREATED_NAME).is((Object)JavaTokenType.IDENTIFIER, new Object[]{b.optional((Object)NON_WILDCARD_TYPE_ARGUMENTS), b.zeroOrMore((Object)JavaPunctuator.DOT, new Object[]{JavaTokenType.IDENTIFIER, b.optional((Object)NON_WILDCARD_TYPE_ARGUMENTS)})});
        b.rule((GrammarRuleKey)INNER_CREATOR).is((Object)JavaTokenType.IDENTIFIER, new Object[]{CLASS_CREATOR_REST});
        b.rule((GrammarRuleKey)ARRAY_CREATOR_REST).is((Object)JavaPunctuator.LBRK, new Object[]{b.firstOf(b.sequence((Object)JavaPunctuator.RBRK, b.zeroOrMore((Object)DIM), new Object[]{ARRAY_INITIALIZER}), b.sequence((Object)EXPRESSION, (Object)JavaPunctuator.RBRK, new Object[]{b.zeroOrMore((Object)DIM_EXPR), b.zeroOrMore((Object)DIM)}))});
        b.rule((GrammarRuleKey)CLASS_CREATOR_REST).is(b.optional((Object)DIAMOND), new Object[]{ARGUMENTS, b.optional((Object)CLASS_BODY)});
        b.rule((GrammarRuleKey)DIAMOND).is((Object)JavaPunctuator.LT, new Object[]{JavaPunctuator.GT});
        b.rule((GrammarRuleKey)ARRAY_INITIALIZER).is((Object)JavaPunctuator.LWING, new Object[]{b.optional((Object)VARIABLE_INITIALIZER, new Object[]{b.zeroOrMore((Object)JavaPunctuator.COMMA, new Object[]{VARIABLE_INITIALIZER})}), b.optional((Object)JavaPunctuator.COMMA), JavaPunctuator.RWING});
        b.rule((GrammarRuleKey)VARIABLE_INITIALIZER).is(b.firstOf((Object)ARRAY_INITIALIZER, (Object)EXPRESSION));
        b.rule((GrammarRuleKey)PAR_EXPRESSION).is((Object)JavaPunctuator.LPAR, new Object[]{EXPRESSION, JavaPunctuator.RPAR});
        b.rule((GrammarRuleKey)QUALIFIED_IDENTIFIER).is((Object)JavaTokenType.IDENTIFIER, new Object[]{b.zeroOrMore((Object)JavaPunctuator.DOT, new Object[]{JavaTokenType.IDENTIFIER})});
        b.rule((GrammarRuleKey)DIM).is((Object)JavaPunctuator.LBRK, new Object[]{JavaPunctuator.RBRK});
        b.rule((GrammarRuleKey)DIM_EXPR).is((Object)JavaPunctuator.LBRK, new Object[]{EXPRESSION, JavaPunctuator.RBRK});
    }

    private JavaGrammar() {
        String name = this.name();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_' && i + 1 < name.length()) {
                sb.append(name.charAt(++i));
                continue;
            }
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        this.internalName = sb.toString();
    }

    public String toString() {
        return this.internalName;
    }
}

