/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.SemanticModelProvider;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.resolve.SemanticModel;

public class SemanticModelVisitor
extends JavaAstVisitor
implements SemanticModelProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticModelVisitor.class);
    private SemanticModel semanticModel;

    public void visitFile(AstNode astNode) {
        if (astNode == null) {
            this.semanticModel = null;
            return;
        }
        try {
            this.semanticModel = SemanticModel.createFor(astNode);
        }
        catch (Exception e) {
            LOG.error("Unable to create symbol table for " + this.getContext().getFile(), (Throwable)e);
            this.semanticModel = null;
            return;
        }
    }

    @Override
    @Nullable
    public SemanticModel semanticModel() {
        return this.semanticModel;
    }
}

