/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import java.util.Map;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.SemanticModelProvider;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.resolve.SemanticModel;

public class SonarSymbolTableVisitor
extends JavaAstVisitor {
    private final SemanticModelProvider semanticModelProvider;
    private final SonarComponents sonarComponents;

    public SonarSymbolTableVisitor(SonarComponents sonarComponents, SemanticModelProvider semanticModelProvider) {
        this.sonarComponents = sonarComponents;
        this.semanticModelProvider = semanticModelProvider;
    }

    public void visitFile(AstNode astNode) {
        SemanticModel semanticModel = this.semanticModelProvider.semanticModel();
        if (semanticModel == null) {
            return;
        }
        Symbolizable symbolizable = this.sonarComponents.symbolizableFor(this.getContext().getFile());
        Symbolizable.SymbolTableBuilder symbolTableBuilder = symbolizable.newSymbolTableBuilder();
        for (Map.Entry<AstNode, org.sonar.java.resolve.Symbol> entry : semanticModel.getSymbols().entrySet()) {
            AstNode declaration = entry.getKey();
            Symbol symbol = symbolTableBuilder.newSymbol(SonarSymbolTableVisitor.startOffsetFor(declaration), SonarSymbolTableVisitor.endOffsetFor(declaration));
            for (AstNode usage : semanticModel.getUsages(entry.getValue())) {
                symbolTableBuilder.newReference(symbol, SonarSymbolTableVisitor.startOffsetFor(usage));
            }
        }
        symbolizable.setSymbolTable(symbolTableBuilder.build());
    }

    private static int startOffsetFor(AstNode astNode) {
        return astNode.getFromIndex();
    }

    private static int endOffsetFor(AstNode astNode) {
        return astNode.getFromIndex() + astNode.getTokenValue().length();
    }
}

