/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.api.SourceProject;

public class PackageVisitor
extends JavaAstVisitor {
    public void visitFile(AstNode astNode) {
        SourceProject sourceProject = (SourceProject)this.getContext().peekSourceCode();
        SourcePackage sourcePackage = PackageVisitor.findOrCreateSourcePackage(sourceProject, this.getPackageKey(astNode));
        this.getContext().addSourceCode((SourceCode)sourcePackage);
    }

    public void leaveFile(AstNode astNode) {
        Preconditions.checkState((boolean)this.getContext().peekSourceCode().isType(SourcePackage.class));
        this.getContext().popSourceCode();
    }

    private static SourcePackage findOrCreateSourcePackage(SourceProject sourceProject, String packageKey) {
        if (sourceProject.hasChildren()) {
            for (SourceCode child : sourceProject.getChildren()) {
                if (!child.getKey().equals(packageKey)) continue;
                return (SourcePackage)child;
            }
        }
        return new SourcePackage(packageKey);
    }

    private String getPackageKey(AstNode astNode) {
        if (astNode != null && astNode.getFirstChild().is(new AstNodeType[]{JavaGrammar.PACKAGE_DECLARATION})) {
            AstNode packageNameNode = astNode.getFirstChild().getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
            return PackageVisitor.getAstNodeValue(packageNameNode).replace('.', '/');
        }
        return "";
    }

    private static String getAstNodeValue(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (AstNode child : astNode.getChildren()) {
            sb.append(child.getTokenValue());
        }
        return sb.toString();
    }
}

