/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.SquidAstVisitor;
import java.util.Collections;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.sslr.parser.LexerlessGrammar;

public class MethodHelper {
    private final AstNode astNode;

    public MethodHelper(AstNode astNode) {
        this.astNode = astNode;
    }

    public static void subscribe(SquidAstVisitor<LexerlessGrammar> visitor) {
        visitor.subscribeTo(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST, JavaGrammar.ANNOTATION_METHOD_REST});
    }

    public boolean isPublic() {
        AstNode node;
        if (this.astNode.is(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST})) {
            node = this.astNode.getFirstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION);
        } else if (this.astNode.is(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST})) {
            node = this.astNode.getFirstAncestor((AstNodeType)JavaGrammar.INTERFACE_BODY_DECLARATION);
        } else if (this.astNode.is(new AstNodeType[]{JavaGrammar.ANNOTATION_METHOD_REST})) {
            node = this.astNode.getFirstAncestor((AstNodeType)JavaGrammar.ANNOTATION_TYPE_ELEMENT_DECLARATION);
        } else {
            throw new IllegalStateException();
        }
        for (AstNode modifierNode : node.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})) {
            if (!modifierNode.getFirstChild().is(new AstNodeType[]{JavaKeyword.PUBLIC})) continue;
            return true;
        }
        return false;
    }

    public boolean isConstructor() {
        return this.astNode.is(new AstNodeType[]{JavaGrammar.CONSTRUCTOR_DECLARATOR_REST});
    }

    public AstNode getReturnType() {
        AstNode typeNode = this.getName().getPreviousAstNode();
        Preconditions.checkState((boolean)typeNode.is(new AstNodeType[]{JavaKeyword.VOID, JavaGrammar.TYPE}));
        return typeNode;
    }

    public AstNode getName() {
        AstNode methodNameNode = this.astNode.is(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.ANNOTATION_METHOD_REST}) ? this.astNode.getPreviousAstNode() : this.astNode.getPreviousSibling();
        Preconditions.checkState((boolean)methodNameNode.is(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
        return methodNameNode;
    }

    public List<AstNode> getParameters() {
        AstNode node = this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETERS});
        if (node == null) {
            return Collections.emptyList();
        }
        return node.getDescendants(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETER_DECLS});
    }

    public boolean hasParameters() {
        return !this.getParameters().isEmpty();
    }

    public List<AstNode> getStatements() {
        AstNode node = this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.METHOD_BODY});
        if (node == null) {
            return Collections.emptyList();
        }
        return node.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK}).getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS}).getChildren();
    }

    public static List<MethodHelper> getMethods(AstNode classOrEnumNode) {
        Preconditions.checkArgument((boolean)classOrEnumNode.is(new AstNodeType[]{JavaGrammar.CLASS_BODY, JavaGrammar.ENUM_BODY_DECLARATIONS}));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AstNode classBodyDeclaration : classOrEnumNode.getChildren(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION})) {
            AstNode memberDecl = classBodyDeclaration.getFirstChild(new AstNodeType[]{JavaGrammar.MEMBER_DECL});
            if (memberDecl == null) continue;
            AstNode actualMember = MethodHelper.getFirstDescendant(memberDecl, new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.FIELD_DECLARATION, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION});
            if (!actualMember.is(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST})) continue;
            builder.add((Object)new MethodHelper(actualMember));
        }
        return builder.build();
    }

    private static AstNode getFirstDescendant(AstNode node, AstNodeType ... nodeTypes) {
        for (AstNode child : node.getChildren()) {
            if (child.is(nodeTypes)) {
                return child;
            }
            AstNode result = MethodHelper.getFirstDescendant(child, nodeTypes);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

