/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Map;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

public class ExpressionVisitor
extends BaseTreeVisitor {
    private final Map<Tree.Kind, Type> typesOfLiterals = Maps.newHashMap();
    private final SemanticModel semanticModel;
    private final Symbols symbols;
    private final Resolve resolve;
    private final Map<Tree, Type> types = Maps.newHashMap();

    public ExpressionVisitor(SemanticModel semanticModel, Symbols symbols, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.symbols = symbols;
        this.resolve = resolve;
        this.typesOfLiterals.put(Tree.Kind.BOOLEAN_LITERAL, symbols.booleanType);
        this.typesOfLiterals.put(Tree.Kind.NULL_LITERAL, symbols.nullType);
        this.typesOfLiterals.put(Tree.Kind.CHAR_LITERAL, symbols.charType);
        this.typesOfLiterals.put(Tree.Kind.STRING_LITERAL, symbols.stringType);
        this.typesOfLiterals.put(Tree.Kind.FLOAT_LITERAL, symbols.floatType);
        this.typesOfLiterals.put(Tree.Kind.DOUBLE_LITERAL, symbols.doubleType);
        this.typesOfLiterals.put(Tree.Kind.LONG_LITERAL, symbols.longType);
        this.typesOfLiterals.put(Tree.Kind.INT_LITERAL, symbols.intType);
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        super.visitExpressionStatement(tree);
        this.types.put((Tree)tree, this.getType((Tree)tree.expression()));
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        IdentifierTree identifier;
        Type type;
        super.visitMethodInvocation(tree);
        ExpressionTree methodSelect = tree.methodSelect();
        Resolve.Env env = this.semanticModel.getEnv((Tree)tree);
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)methodSelect;
            type = this.getType((Tree)mset.expression());
            identifier = mset.identifier();
        } else if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            type = env.enclosingClass.type;
            identifier = (IdentifierTree)methodSelect;
        } else {
            throw new IllegalStateException("Method select in method invocation is not of the expected type " + methodSelect);
        }
        String name = identifier.name();
        if (type == null) {
            type = this.symbols.unknownType;
        }
        Symbol symbol = this.resolve.findMethod(env, type.symbol, name, (List<Type>)ImmutableList.of());
        this.associateReference(identifier, symbol);
        type = this.getTypeOfSymbol(symbol);
        if (type == null) {
            type = this.symbols.unknownType;
        }
        this.types.put((Tree)tree, type);
    }

    public void visitInstanceOf(InstanceOfTree tree) {
        super.visitInstanceOf(tree);
        this.types.put((Tree)tree, this.symbols.booleanType);
    }

    public void visitParameterizedType(ParameterizedTypeTree tree) {
        super.visitParameterizedType(tree);
        this.types.put((Tree)tree, this.symbols.unknownType);
    }

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        super.visitConditionalExpression(tree);
        this.types.put((Tree)tree, this.symbols.unknownType);
    }

    public void visitLambdaExpression(LambdaExpressionTree tree) {
        super.visitLambdaExpression(tree);
        this.types.put((Tree)tree, this.symbols.unknownType);
    }

    public void visitNewArray(NewArrayTree tree) {
        super.visitNewArray(tree);
        Type type = this.getType(tree.type());
        int dimensions = tree.dimensions().size();
        type = new Type.ArrayType(type, this.symbols.arrayClass);
        for (int i = 1; i < dimensions; ++i) {
            type = new Type.ArrayType(type, this.symbols.arrayClass);
        }
        this.types.put((Tree)tree, type);
    }

    public void visitParenthesized(ParenthesizedTree tree) {
        super.visitParenthesized(tree);
        this.types.put((Tree)tree, this.getType((Tree)tree.expression()));
    }

    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        super.visitArrayAccessExpression(tree);
        Type type = this.getType((Tree)tree.expression());
        if (type != null && type.tag == 11) {
            this.types.put((Tree)tree, ((Type.ArrayType)type).elementType);
        } else {
            this.types.put((Tree)tree, this.symbols.unknownType);
        }
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        Resolve.Env env = this.semanticModel.getEnv((Tree)tree);
        Type left = this.getType((Tree)tree.leftOperand());
        AstNode astNode = ((JavaTree)tree).getAstNode();
        AstNode opNode = astNode.getFirstChild().getNextSibling();
        Type right = this.getType((Tree)tree.rightOperand());
        if (left == null || right == null) {
            this.types.put((Tree)tree, this.symbols.unknownType);
            return;
        }
        Symbol symbol = this.resolve.findMethod(env, opNode.getTokenValue(), (List<Type>)ImmutableList.of((Object)left, (Object)right));
        if (symbol.kind != 16) {
            this.types.put((Tree)tree, this.symbols.unknownType);
            return;
        }
        this.types.put((Tree)tree, ((Type.MethodType)symbol.type).resultType);
    }

    public void visitNewClass(NewClassTree tree) {
        super.visitNewClass(tree);
        if (tree.classBody() != null) {
            this.types.put((Tree)tree, this.symbols.unknownType);
        } else {
            this.types.put((Tree)tree, this.getType(tree.identifier()));
        }
    }

    public void visitPrimitiveType(PrimitiveTypeTree tree) {
        AstNode astNode = ((JavaTree)tree).getAstNode();
        Type type = this.resolve.findIdent((Resolve.Env)this.semanticModel.getEnv((Tree)tree), (String)astNode.getLastChild().getTokenValue(), (int)2).type;
        this.types.put((Tree)tree, type);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.types.put((Tree)tree, this.getType((Tree)tree.variable()));
    }

    public void visitLiteral(LiteralTree tree) {
        super.visitLiteral(tree);
        Type type = this.typesOfLiterals.get(((JavaTree)tree).getKind());
        this.types.put((Tree)tree, type);
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        super.visitUnaryExpression(tree);
        this.types.put((Tree)tree, this.getType((Tree)tree.expression()));
    }

    public void visitArrayType(ArrayTypeTree tree) {
        super.visitArrayType(tree);
        this.types.put((Tree)tree, new Type.ArrayType(this.getType(tree.type()), this.symbols.arrayClass));
    }

    public void visitTypeCast(TypeCastTree tree) {
        super.visitTypeCast(tree);
        this.types.put((Tree)tree, this.getType(tree.type()));
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.scan((Tree)tree.modifiers());
        NewClassTree newClassTree = (NewClassTree)tree.initializer();
        this.scan((Tree)newClassTree.enclosingExpression());
        this.scan(newClassTree.typeArguments());
        this.scan(newClassTree.arguments());
        this.scan((Tree)newClassTree.classBody());
    }

    public void visitIdentifier(IdentifierTree tree) {
        Symbol symbol = this.resolve.findIdent(this.semanticModel.getEnv((Tree)tree), tree.name(), 7);
        this.associateReference(tree, symbol);
        this.types.put((Tree)tree, this.getTypeOfSymbol(symbol));
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.resolveQualifiedIdentifier((Tree)tree);
    }

    public void visitAnnotation(AnnotationTree tree) {
        super.visitAnnotation(tree);
        this.types.put((Tree)tree, this.symbols.unknownType);
    }

    private void resolveQualifiedIdentifier(Tree tree) {
        final Resolve.Env env = this.semanticModel.getEnv(tree);
        class FQV
        extends BaseTreeVisitor {
            private Symbol site;

            FQV() {
            }

            public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
                this.scan((Tree)tree.expression());
                String name = tree.identifier().name();
                if (JavaKeyword.CLASS.getValue().equals(name)) {
                    ExpressionVisitor.this.types.put(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.classType);
                    return;
                }
                if (this.site.kind >= 64) {
                    ExpressionVisitor.this.types.put(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.unknownType);
                    return;
                }
                if (this.site.kind == 4) {
                    Type siteType = ((Symbol.VariableSymbol)this.site).type;
                    if (siteType == null) {
                        ExpressionVisitor.this.types.put(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.unknownType);
                        return;
                    }
                    this.site = ExpressionVisitor.this.resolve.findIdentInType(env, siteType.symbol, name, 6);
                } else if (this.site.kind == 2) {
                    this.site = ExpressionVisitor.this.resolve.findIdentInType(env, (Symbol.TypeSymbol)this.site, name, 6);
                } else if (this.site.kind == 1) {
                    this.site = ExpressionVisitor.this.resolve.findIdentInPackage(env, this.site, name, 5);
                } else {
                    throw new IllegalStateException();
                }
                ExpressionVisitor.this.associateReference(tree.identifier(), this.site);
                ExpressionVisitor.this.types.put(tree, ExpressionVisitor.this.getTypeOfSymbol(this.site));
            }

            public void visitArrayType(ArrayTypeTree tree) {
                super.visitArrayType(tree);
                ExpressionVisitor.this.types.put(tree, new Type.ArrayType(ExpressionVisitor.this.getType(tree.type()), ((ExpressionVisitor)ExpressionVisitor.this).symbols.arrayClass));
            }

            public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
                super.visitArrayAccessExpression(tree);
                Type arrayType = ExpressionVisitor.this.getType((Tree)tree.expression());
                if (arrayType != null && arrayType.tag == 11) {
                    this.site = arrayType.symbol;
                    ExpressionVisitor.this.types.put(tree, ((Type.ArrayType)arrayType).elementType);
                } else {
                    ExpressionVisitor.this.types.put(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.unknownType);
                }
            }

            public void visitIdentifier(IdentifierTree tree) {
                this.site = ExpressionVisitor.this.resolve.findIdent(ExpressionVisitor.this.semanticModel.getEnv((Tree)tree), tree.name(), 7);
                ExpressionVisitor.this.associateReference(tree, this.site);
                ExpressionVisitor.this.types.put(tree, ExpressionVisitor.this.getTypeOfSymbol(this.site));
            }

            public void visitLiteral(LiteralTree tree) {
                Type literalType = (Type)ExpressionVisitor.this.typesOfLiterals.get(((JavaTree)tree).getKind());
                this.site = literalType.symbol;
                ExpressionVisitor.this.types.put(tree, literalType);
            }

            public void visitPrimitiveType(PrimitiveTypeTree tree) {
                AstNode astNode = ((JavaTree)tree).getAstNode();
                this.site = ExpressionVisitor.this.resolve.findIdent(ExpressionVisitor.this.semanticModel.getEnv((Tree)tree), astNode.getLastChild().getTokenValue(), 2);
                ExpressionVisitor.this.types.put(tree, this.site.type);
            }
        }
        FQV visitor = new FQV();
        tree.accept((TreeVisitor)visitor);
    }

    private Type getTypeOfSymbol(Symbol symbol) {
        if (symbol.kind < 64) {
            return symbol.type;
        }
        return this.symbols.unknownType;
    }

    @VisibleForTesting
    Type getType(Tree tree) {
        return this.types.get(tree);
    }

    private void associateReference(IdentifierTree tree, Symbol symbol) {
        if (symbol.kind < 64 && this.semanticModel.getTree(symbol) != null) {
            this.semanticModel.associateReference(tree, symbol);
        }
    }
}

