/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.ExpressionVisitor;
import org.sonar.java.resolve.FirstPass;
import org.sonar.java.resolve.LabelsVisitor;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SemanticModel {
    private final BiMap<Tree, Symbol> symbolsTree = HashBiMap.create();
    private Multimap<Symbol, IdentifierTree> usagesTree = HashMultimap.create();
    private final Map<Symbol, Resolve.Env> symbolEnvs = Maps.newHashMap();
    private final Map<AstNode, Resolve.Env> envs = Maps.newHashMap();

    public static SemanticModel createFor(CompilationUnitTree tree) {
        Symbols symbols = new Symbols();
        Resolve resolve = new Resolve(symbols);
        SemanticModel semanticModel = new SemanticModel();
        new FirstPass(semanticModel, resolve).visitCompilationUnit(tree);
        new ExpressionVisitor(semanticModel, symbols, resolve).visitCompilationUnit(tree);
        new LabelsVisitor(semanticModel).visitCompilationUnit(tree);
        return semanticModel;
    }

    @VisibleForTesting
    SemanticModel() {
    }

    public void saveEnv(Symbol symbol, Resolve.Env env) {
        this.symbolEnvs.put(symbol, env);
    }

    public Resolve.Env getEnv(Symbol symbol) {
        return this.symbolEnvs.get(symbol);
    }

    public void associateEnv(Tree tree, Resolve.Env env) {
        this.envs.put(((JavaTree)tree).getAstNode(), env);
    }

    public Resolve.Env getEnv(Tree tree) {
        Resolve.Env result = null;
        for (AstNode astNode = ((JavaTree)tree).getAstNode(); result == null && astNode != null; astNode = astNode.getParent()) {
            result = this.envs.get(astNode);
        }
        return result;
    }

    public void associateSymbol(Tree tree, Symbol symbol) {
        Preconditions.checkNotNull((Object)symbol);
        this.symbolsTree.put((Object)tree, (Object)symbol);
    }

    public Symbol getSymbol(Tree tree) {
        return (Symbol)this.symbolsTree.get((Object)tree);
    }

    public Tree getTree(Symbol symbol) {
        return (Tree)this.symbolsTree.inverse().get((Object)symbol);
    }

    public void associateReference(IdentifierTree tree, Symbol symbol) {
        this.usagesTree.put((Object)symbol, (Object)tree);
    }

    public Map<Tree, Symbol> getSymbolsTree() {
        return Collections.unmodifiableMap(this.symbolsTree);
    }

    public Collection<IdentifierTree> getUsages(Symbol symbol) {
        return Collections.unmodifiableCollection(this.usagesTree.get((Object)symbol));
    }
}

