/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AuditListener;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.ast.AstWalker;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.InputFile;
import org.sonar.java.ProgressReport;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.visitors.VisitorContext;
import org.sonar.squidbridge.CommentAnalyser;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContext;
import org.sonar.squidbridge.api.AnalysisException;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceCodeIndexer;
import org.sonar.squidbridge.api.SourceCodeSearchEngine;
import org.sonar.squidbridge.api.SourceCodeTreeDecorator;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.SquidIndex;
import org.sonar.squidbridge.measures.Metric;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class AstScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AstScanner.class);
    private final SquidIndex index;
    private final List<SquidAstVisitor<LexerlessGrammar>> visitors = Lists.newArrayList();
    private final List<AuditListener> auditListeners = Lists.newArrayList();
    private final Parser<LexerlessGrammar> parser;
    private CommentAnalyser commentAnalyser;

    public AstScanner(Parser<LexerlessGrammar> parser) {
        this.parser = parser;
        this.index = new SquidIndex();
    }

    public AstScanner(AstScanner astScanner) {
        this.parser = astScanner.parser;
        this.index = astScanner.index;
    }

    public void scan(Collection<InputFile> files) {
        SourceProject project = new SourceProject("Java Project");
        this.index.index((SourceCode)project);
        project.setSourceCodeIndexer((SourceCodeIndexer)this.index);
        VisitorContext context = new VisitorContext(project);
        context.setCommentAnalyser(this.commentAnalyser);
        this.simpleScan(files);
        SourceCodeTreeDecorator decorator = new SourceCodeTreeDecorator(project);
        decorator.decorateWith((MetricDef[])JavaMetric.values());
        decorator.decorateWith((MetricDef[])Metric.values());
    }

    public void simpleScan(Collection<InputFile> files) {
        SourceProject project = (SourceProject)this.index.search("Java Project");
        VisitorContext context = new VisitorContext(project);
        context.setCommentAnalyser(this.commentAnalyser);
        for (SquidAstVisitor<LexerlessGrammar> visitor : this.visitors) {
            visitor.setContext((SquidAstVisitorContext)context);
            visitor.init();
        }
        AstWalker astWalker = new AstWalker(this.visitors);
        ProgressReport progressReport = new ProgressReport("Report about progress of Java AST analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start(files.size() + " source files to be analyzed");
        int count = 0;
        for (InputFile inputFile : files) {
            File file = inputFile.getFile();
            progressReport.message(count + "/" + files.size() + " files analyzed, current is " + file.getAbsolutePath());
            ++count;
            context.setFile(file);
            try {
                AstNode ast = this.parser.parse(file);
                astWalker.walkAndVisit(ast);
            }
            catch (RecognitionException e) {
                LOG.error("Unable to parse source file : " + file.getAbsolutePath());
                LOG.error(e.getMessage());
                this.parseErrorWalkAndVisit(e, file);
            }
            catch (Exception e) {
                throw new AnalysisException(AstScanner.getAnalyisExceptionMessage(file), (Throwable)e);
            }
        }
        progressReport.stop(files.size() + "/" + files.size() + " source files analyzed");
        for (SquidAstVisitor squidAstVisitor : this.visitors) {
            squidAstVisitor.destroy();
        }
    }

    private void parseErrorWalkAndVisit(RecognitionException e, File file) {
        try {
            for (SquidAstVisitor<LexerlessGrammar> squidAstVisitor : this.visitors) {
                squidAstVisitor.visitFile(null);
            }
            for (AuditListener auditListener : this.auditListeners) {
                auditListener.processRecognitionException(e);
            }
            for (SquidAstVisitor squidAstVisitor : Lists.reverse(this.visitors)) {
                squidAstVisitor.leaveFile(null);
            }
        }
        catch (Exception e2) {
            throw new AnalysisException(AstScanner.getAnalyisExceptionMessage(file), (Throwable)e2);
        }
    }

    private static String getAnalyisExceptionMessage(File file) {
        return "SonarQube is unable to analyze file : '" + file.getAbsolutePath() + "'";
    }

    public void withSquidAstVisitor(SquidAstVisitor<LexerlessGrammar> visitor) {
        if (visitor instanceof AuditListener) {
            this.auditListeners.add((AuditListener)visitor);
        }
        this.visitors.add(visitor);
    }

    public SourceCodeSearchEngine getIndex() {
        return this.index;
    }

    public void setCommentAnalyser(CommentAnalyser commentAnalyser) {
        this.commentAnalyser = commentAnalyser;
    }

    public void accept(CodeVisitor visitor) {
        if (visitor instanceof SquidAstVisitor) {
            this.withSquidAstVisitor((SquidAstVisitor<LexerlessGrammar>)((SquidAstVisitor)visitor));
        }
    }
}

