/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;

public class AnonymousInnerClassVisitor
extends JavaAstVisitor {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_CREATOR_REST});
    }

    public void visitNode(AstNode astNode) {
        if (this.isInnerClass(astNode)) {
            SourceClass parentClass = this.peekSourceClass();
            int anonymousInnerClassNo = this.determineAnonymousInnerClassNo(parentClass);
            String anonymousInnerClassName = parentClass.getName() + "$" + anonymousInnerClassNo;
            String anonymousInnerClassKey = parentClass.getKey() + "$" + anonymousInnerClassNo;
            SourceClass anonymousInnerClass = new SourceClass(anonymousInnerClassKey, anonymousInnerClassName);
            anonymousInnerClass.setStartAtLine(astNode.getTokenLine());
            this.getContext().addSourceCode((SourceCode)anonymousInnerClass);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (this.isInnerClass(astNode)) {
            this.getContext().popSourceCode();
        }
    }

    private int determineAnonymousInnerClassNo(SourceClass parentClass) {
        int anonymousInnerClassNo = 1;
        SourceClass anonymousInnerClass;
        while (parentClass.hasChild((SourceCode)(anonymousInnerClass = new SourceClass(parentClass.getKey() + "$" + anonymousInnerClassNo)))) {
            ++anonymousInnerClassNo;
        }
        return anonymousInnerClassNo;
    }

    private boolean isInnerClass(AstNode astNode) {
        return astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.CLASS_BODY});
    }
}

