/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Set;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.measures.MetricDef;

public class CommentLinesVisitor
extends JavaAstVisitor
implements AstAndTokenVisitor {
    private Set<Integer> comments = Sets.newHashSet();
    private boolean seenFirstToken;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.RWING});
    }

    public void visitFile(AstNode astNode) {
        this.comments.clear();
        this.seenFirstToken = false;
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            if (this.seenFirstToken) {
                String[] commentLines = this.getContext().getCommentAnalyser().getContents(trivia.getToken().getOriginalValue()).split("(\r)?\n|\r", -1);
                int line = trivia.getToken().getLine();
                for (String commentLine : commentLines) {
                    if (!commentLine.contains("NOSONAR") && !this.getContext().getCommentAnalyser().isBlank(commentLine)) {
                        this.comments.add(line);
                    }
                    ++line;
                }
                continue;
            }
            this.seenFirstToken = true;
        }
        this.seenFirstToken = true;
    }

    public void leaveNode(AstNode astNode) {
        SourceCode sourceCode = this.getContext().peekSourceCode();
        int commentlines = 0;
        for (int line = sourceCode.getStartAtLine(); line <= sourceCode.getEndAtLine(); ++line) {
            if (!this.comments.contains(line)) continue;
            ++commentlines;
        }
        sourceCode.setMeasure((MetricDef)JavaMetric.COMMENT_LINES_WITHOUT_HEADER, commentlines);
    }

    public void leaveFile(AstNode ast) {
        this.getContext().peekSourceCode().setMeasure((MetricDef)JavaMetric.COMMENT_LINES_WITHOUT_HEADER, this.comments.size());
        this.comments.clear();
    }
}

