/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import java.util.Set;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.measures.MetricDef;

public class LinesOfCodeVisitor
extends JavaAstVisitor
implements AstAndTokenVisitor {
    private Set<Integer> lines = Sets.newHashSet();

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.RWING});
    }

    public void visitFile(AstNode astNode) {
        this.lines.clear();
    }

    public void visitToken(Token token) {
        if (token.getType() != GenericTokenType.EOF) {
            this.lines.add(token.getLine());
        }
    }

    public void leaveNode(AstNode astNode) {
        SourceCode sourceCode = this.getContext().peekSourceCode();
        int linesOfCode = 0;
        for (int line = sourceCode.getStartAtLine(); line <= sourceCode.getEndAtLine(); ++line) {
            if (!this.lines.contains(line)) continue;
            ++linesOfCode;
        }
        sourceCode.setMeasure((MetricDef)JavaMetric.LINES_OF_CODE, linesOfCode);
    }

    public void leaveFile(AstNode astNode) {
        this.getContext().peekSourceCode().setMeasure((MetricDef)JavaMetric.LINES_OF_CODE, this.lines.size());
        this.lines.clear();
    }
}

