/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourcePackage;
import org.sonar.squidbridge.api.SourceProject;

public class PackageVisitor
extends JavaAstVisitor {
    public static final String UNRESOLVED_PACKAGE = "!error!";

    public void visitFile(AstNode astNode) {
        SourceProject sourceProject = (SourceProject)this.getContext().peekSourceCode();
        SourcePackage sourcePackage = PackageVisitor.findOrCreateSourcePackage(sourceProject, this.getPackageKey(astNode));
        this.getContext().addSourceCode((SourceCode)sourcePackage);
    }

    public void leaveFile(AstNode astNode) {
        Preconditions.checkState((boolean)this.getContext().peekSourceCode().isType(SourcePackage.class));
        this.getContext().popSourceCode();
    }

    private static SourcePackage findOrCreateSourcePackage(SourceProject sourceProject, String packageKey) {
        if (sourceProject.hasChildren()) {
            for (SourceCode child : sourceProject.getChildren()) {
                if (!child.getKey().equals(packageKey)) continue;
                return (SourcePackage)child;
            }
        }
        return new SourcePackage(packageKey);
    }

    private String getPackageKey(AstNode astNode) {
        if (this.isEmptyFileOrParseError(astNode)) {
            return UNRESOLVED_PACKAGE;
        }
        if (astNode.getFirstChild().is(new AstNodeType[]{JavaGrammar.PACKAGE_DECLARATION})) {
            AstNode packageNameNode = astNode.getFirstChild().getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
            return PackageVisitor.getAstNodeValue(packageNameNode).replace('.', '/');
        }
        return "";
    }

    private boolean isEmptyFileOrParseError(AstNode astNode) {
        return astNode == null || astNode.getFirstChild().is(new AstNodeType[]{GenericTokenType.EOF});
    }

    private static String getAstNodeValue(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (AstNode child : astNode.getChildren()) {
            sb.append(child.getTokenValue());
        }
        return sb.toString();
    }
}

