/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public abstract class JavaTree
implements Tree {
    protected final AstNode astNode;

    public JavaTree(AstNode astNode) {
        this.astNode = astNode;
    }

    public AstNode getAstNode() {
        return this.astNode;
    }

    public int getLine() {
        return this.astNode.getTokenLine();
    }

    @Override
    public final boolean is(Tree.Kind kind) {
        return this.getKind() == null ? false : this.getKind() == kind;
    }

    public abstract Tree.Kind getKind();

    public abstract Iterator<Tree> childrenIterator();

    public boolean isLeaf() {
        return false;
    }

    public static class ArrayTypeTreeImpl
    extends AbstractTypedTree
    implements ArrayTypeTree {
        private final Tree type;

        public ArrayTypeTreeImpl(AstNode astNode, Tree type) {
            super(astNode);
            this.type = (Tree)Preconditions.checkNotNull((Object)type);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ARRAY_TYPE;
        }

        @Override
        public Tree type() {
            return this.type;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitArrayType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.singletonIterator((Object)this.type);
        }
    }

    public static class ParameterizedTypeTreeImpl
    extends AbstractTypedTree
    implements ParameterizedTypeTree,
    ExpressionTree {
        private final ExpressionTree type;
        private final List<Tree> typeArguments;

        public ParameterizedTypeTreeImpl(AstNode child, ExpressionTree type, List<Tree> typeArguments) {
            super(child);
            this.type = (ExpressionTree)Preconditions.checkNotNull((Object)type);
            this.typeArguments = (List)Preconditions.checkNotNull(typeArguments);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PARAMETERIZED_TYPE;
        }

        @Override
        public Tree type() {
            return this.type;
        }

        @Override
        public List<Tree> typeArguments() {
            return this.typeArguments;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitParameterizedType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.type), this.typeArguments.iterator());
        }
    }

    public static class PrimitiveTypeTreeImpl
    extends AbstractTypedTree
    implements PrimitiveTypeTree {
        public PrimitiveTypeTreeImpl(AstNode astNode) {
            super(astNode);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PRIMITIVE_TYPE;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitPrimitiveType(this);
        }

        @Override
        public SyntaxToken keyword() {
            return new InternalSyntaxToken(this.astNode.getLastToken());
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            throw new UnsupportedOperationException();
        }
    }

    public static class NotImplementedTreeImpl
    extends AbstractTypedTree
    implements ExpressionTree {
        private String name;

        public NotImplementedTreeImpl(AstNode astNode, String name) {
            super(astNode);
            this.name = name;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.OTHER;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitOther(this);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            throw new UnsupportedOperationException();
        }
    }

    public static class UnionTypeTreeImpl
    extends JavaTree
    implements UnionTypeTree {
        private final List<Tree> typeAlternatives;

        public UnionTypeTreeImpl(AstNode astNode, List<Tree> typeAlternatives) {
            super(astNode);
            this.typeAlternatives = (List)Preconditions.checkNotNull(typeAlternatives);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.UNION_TYPE;
        }

        @Override
        public List<Tree> typeAlternatives() {
            return this.typeAlternatives;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitUnionType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat((Iterator)Iterators.emptyIterator(), this.typeAlternatives.iterator());
        }
    }

    public static class WildcardTreeImpl
    extends JavaTree
    implements WildcardTree {
        private final Tree.Kind kind;
        @Nullable
        private final Tree bound;

        public WildcardTreeImpl(AstNode astNode, Tree.Kind kind, @Nullable Tree bound) {
            super(astNode);
            this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
            this.bound = bound;
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        @Override
        @Nullable
        public Tree bound() {
            return this.bound;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitWildcard(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.singletonIterator((Object)this.bound);
        }
    }

    public static class ImportTreeImpl
    extends JavaTree
    implements ImportTree {
        private final boolean isStatic;
        private final Tree qualifiedIdentifier;

        public ImportTreeImpl(AstNode astNode, boolean aStatic, Tree qualifiedIdentifier) {
            super(astNode);
            this.isStatic = aStatic;
            this.qualifiedIdentifier = qualifiedIdentifier;
        }

        @Override
        public Tree.Kind getKind() {
            return null;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        @Override
        public Tree qualifiedIdentifier() {
            return this.qualifiedIdentifier;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitImport(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.singletonIterator((Object)this.qualifiedIdentifier);
        }
    }

    public static class CompilationUnitTreeImpl
    extends JavaTree
    implements CompilationUnitTree {
        @Nullable
        private final ExpressionTree packageName;
        private final List<ImportTree> imports;
        private final List<Tree> types;
        private final List<AnnotationTree> packageAnnotations;

        public CompilationUnitTreeImpl(AstNode astNode, @Nullable ExpressionTree packageName, List<ImportTree> imports, List<Tree> types, List<AnnotationTree> packageAnnotations) {
            super(astNode);
            this.packageName = packageName;
            this.imports = (List)Preconditions.checkNotNull(imports);
            this.types = (List)Preconditions.checkNotNull(types);
            this.packageAnnotations = (List)Preconditions.checkNotNull(packageAnnotations);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.COMPILATION_UNIT;
        }

        @Override
        public List<AnnotationTree> packageAnnotations() {
            return this.packageAnnotations;
        }

        @Override
        @Nullable
        public ExpressionTree packageName() {
            return this.packageName;
        }

        @Override
        public List<ImportTree> imports() {
            return this.imports;
        }

        @Override
        public List<Tree> types() {
            return this.types;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitCompilationUnit(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.packageName), this.imports.iterator(), this.types.iterator(), this.packageAnnotations.iterator());
        }
    }
}

