/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.JavaTreeMaker;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

public class VisitorsBridge
extends JavaAstVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(VisitorsBridge.class);
    private final JavaTreeMaker treeMaker = new JavaTreeMaker();
    private final List<JavaFileScanner> scanners;
    private SemanticModel semanticModel;
    private SonarComponents sonarComponents;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Arrays.asList(visitor), null);
    }

    public VisitorsBridge(Iterable visitors, @Nullable SonarComponents sonarComponents) {
        ImmutableList.Builder scannersBuilder = ImmutableList.builder();
        for (Object visitor : visitors) {
            if (!(visitor instanceof JavaFileScanner)) continue;
            scannersBuilder.add((Object)((JavaFileScanner)visitor));
        }
        this.scanners = scannersBuilder.build();
        this.sonarComponents = sonarComponents;
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.semanticModel = null;
        if (astNode != null) {
            CompilationUnitTree tree = this.treeMaker.compilationUnit(astNode);
            if (this.isNotJavaLangOrSerializable()) {
                try {
                    this.semanticModel = SemanticModel.createFor(tree, this.getProjectClasspath());
                }
                catch (Exception e) {
                    LOG.error("Unable to create symbol table for : " + this.getContext().getFile().getName(), (Throwable)e);
                    return;
                }
                this.createSonarSymbolTable(tree);
            } else {
                SemanticModel.handleMissingTypes(tree);
            }
            DefaultJavaFileScannerContext context = new DefaultJavaFileScannerContext(tree, this.peekSourceFile(), this.semanticModel);
            for (JavaFileScanner scanner : this.scanners) {
                scanner.scanFile(context);
            }
        }
    }

    private boolean isNotJavaLangOrSerializable() {
        String[] path = this.peekSourceFile().getName().split(Pattern.quote(File.separator));
        boolean isJavaLang = path.length > 3 && "java".equals(path[path.length - 3]) && "lang".equals(path[path.length - 2]);
        boolean isJavaLangAnnotation = path.length > 4 && "Annotation.java".equals(path[path.length - 1]) && "java".equals(path[path.length - 4]) && "lang".equals(path[path.length - 3]) && "annotation".equals(path[path.length - 2]);
        boolean isSerializable = path.length > 3 && "Serializable.java".equals(path[path.length - 1]) && "java".equals(path[path.length - 3]) && "io".equals(path[path.length - 2]);
        return !isJavaLang && !isJavaLangAnnotation && !isSerializable;
    }

    private List<File> getProjectClasspath() {
        List<Object> projectClasspath = Lists.newArrayList();
        if (this.sonarComponents != null) {
            projectClasspath = this.sonarComponents.getProjectClasspath();
        }
        return projectClasspath;
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.getContext().getFile()), this.semanticModel);
            symVisitor.visitCompilationUnit(tree);
        }
    }

    private static class DefaultJavaFileScannerContext
    implements JavaFileScannerContext {
        private final CompilationUnitTree tree;
        private final SourceFile sourceFile;
        private final SemanticModel semanticModel;

        public DefaultJavaFileScannerContext(CompilationUnitTree tree, SourceFile sourceFile, SemanticModel semanticModel) {
            this.tree = tree;
            this.sourceFile = sourceFile;
            this.semanticModel = semanticModel;
        }

        @Override
        public CompilationUnitTree getTree() {
            return this.tree;
        }

        @Override
        public void addIssue(Tree tree, RuleKey ruleKey, String message) {
            Preconditions.checkNotNull((Object)ruleKey);
            Preconditions.checkNotNull((Object)message);
            int line = ((JavaTree)tree).getLine();
            CheckMessage checkMessage = new CheckMessage((Object)ruleKey, message, new Object[0]);
            checkMessage.setLine(line);
            this.sourceFile.log(checkMessage);
        }

        @Override
        @Nullable
        public Object getSemanticModel() {
            return this.semanticModel;
        }

        @Override
        public String getFileName() {
            return this.sourceFile.getName();
        }
    }
}

