/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ClassTreeImpl
extends JavaTree
implements ClassTree {
    private final Tree.Kind kind;
    private final ModifiersTree modifiers;
    private final IdentifierTree simpleName;
    @Nullable
    private final Tree superClass;
    private final List<Tree> superInterfaces;
    private final List<Tree> members;
    @Nullable
    private Symbol.TypeSymbol symbol;

    public ClassTreeImpl(AstNode astNode, Tree.Kind kind, ModifiersTree modifiers, @Nullable IdentifierTree simpleName, @Nullable Tree superClass, List<Tree> superInterfaces, List<Tree> members) {
        super(astNode);
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
        this.simpleName = simpleName;
        this.superClass = superClass;
        this.superInterfaces = (List)Preconditions.checkNotNull(superInterfaces);
        this.members = (List)Preconditions.checkNotNull(members);
    }

    public ClassTreeImpl(AstNode astNode, Tree.Kind kind, ModifiersTree modifiers, List<Tree> members) {
        this(astNode, kind, modifiers, null, null, (List<Tree>)ImmutableList.of(), members);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    @Nullable
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    public List<Tree> typeParameters() {
        return ImmutableList.of();
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    @Nullable
    public Tree superClass() {
        return this.superClass;
    }

    @Override
    public List<Tree> superInterfaces() {
        return this.superInterfaces;
    }

    @Override
    public List<Tree> members() {
        return this.members;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitClass(this);
    }

    @Nullable
    public Symbol.TypeSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol.TypeSymbol symbol) {
        Preconditions.checkState((this.symbol == null ? 1 : 0) != 0);
        this.symbol = symbol;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.forArray((Object[])new Tree[]{this.modifiers, this.simpleName, this.superClass}), this.superInterfaces.iterator(), this.members.iterator());
    }
}

