/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class InstanceOfTreeImpl
extends AbstractTypedTree
implements InstanceOfTree {
    private final ExpressionTree expression;
    private final Tree type;

    public InstanceOfTreeImpl(AstNode astNode, ExpressionTree expression, Tree type) {
        super(astNode);
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.type = (Tree)Preconditions.checkNotNull((Object)type);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.INSTANCE_OF;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken instanceofKeyword() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaKeyword.INSTANCEOF}).getToken());
    }

    @Override
    public Tree type() {
        return this.type;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitInstanceOf(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.expression, this.type});
    }
}

