/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class BlockTreeImpl
extends JavaTree
implements BlockTree {
    private final Tree.Kind kind;
    private final List<StatementTree> body;

    public BlockTreeImpl(AstNode astNode, Tree.Kind kind, List<StatementTree> body) {
        super(astNode);
        this.kind = kind;
        this.body = (List)Preconditions.checkNotNull(body);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public SyntaxToken openBraceToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.LWING}).getToken());
    }

    @Override
    public List<StatementTree> body() {
        return this.body;
    }

    @Override
    public SyntaxToken closeBraceToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.RWING}).getToken());
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBlock(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.emptyIterator(), this.body.iterator());
    }
}

