/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ExpressionStatementTreeImpl
extends JavaTree
implements ExpressionStatementTree {
    private final ExpressionTree expression;

    public ExpressionStatementTreeImpl(AstNode astNode, ExpressionTree expression) {
        super(astNode);
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXPRESSION_STATEMENT;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken semicolonToken() {
        if (this.astNode.is(new AstNodeType[]{JavaGrammar.EXPRESSION_STATEMENT})) {
            return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.SEMI}).getToken());
        }
        if (this.astNode.is(new AstNodeType[]{JavaGrammar.STATEMENT_EXPRESSION})) {
            return new InternalSyntaxToken(this.astNode.getParent().getFirstChild(new AstNodeType[]{JavaPunctuator.SEMI}).getToken());
        }
        throw new IllegalStateException();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitExpressionStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.expression);
    }
}

