/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ForStatementTreeImpl
extends JavaTree
implements ForStatementTree {
    private final List<StatementTree> initializer;
    @Nullable
    private final ExpressionTree condition;
    private final List<StatementTree> update;
    private final StatementTree statement;

    public ForStatementTreeImpl(AstNode astNode, List<StatementTree> initializer, @Nullable ExpressionTree condition, List<StatementTree> update, StatementTree statement) {
        super(astNode);
        this.initializer = (List)Preconditions.checkNotNull(initializer);
        this.condition = condition;
        this.update = (List)Preconditions.checkNotNull(update);
        this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FOR_STATEMENT;
    }

    @Override
    public SyntaxToken forKeyword() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaKeyword.FOR}).getToken());
    }

    @Override
    public SyntaxToken openParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}).getToken());
    }

    @Override
    public List<StatementTree> initializer() {
        return this.initializer;
    }

    @Override
    public SyntaxToken firstSemicolonToken() {
        return new InternalSyntaxToken(((AstNode)this.astNode.getChildren(new AstNodeType[]{JavaPunctuator.SEMI}).get(0)).getToken());
    }

    @Override
    @Nullable
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken secondSemicolonToken() {
        return new InternalSyntaxToken(((AstNode)this.astNode.getChildren(new AstNodeType[]{JavaPunctuator.SEMI}).get(1)).getToken());
    }

    @Override
    public List<StatementTree> update() {
        return this.update;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}).getToken());
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitForStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.initializer.iterator(), (Iterator)Iterators.singletonIterator((Object)this.condition), this.update.iterator(), (Iterator)Iterators.singletonIterator((Object)this.statement));
    }
}

