/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class LabeledStatementTreeImpl
extends JavaTree
implements LabeledStatementTree {
    private final IdentifierTree label;
    private final StatementTree statement;

    public LabeledStatementTreeImpl(AstNode astNode, IdentifierTree label, StatementTree statement) {
        super(astNode);
        this.label = (IdentifierTree)Preconditions.checkNotNull((Object)label);
        this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LABELED_STATEMENT;
    }

    @Override
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    public SyntaxToken colonToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.COLON}).getToken());
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitLabeledStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.label, this.statement});
    }
}

