/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class SwitchStatementTreeImpl
extends JavaTree
implements SwitchStatementTree {
    private final ExpressionTree expression;
    private final List<CaseGroupTree> cases;

    public SwitchStatementTreeImpl(AstNode astNode, ExpressionTree expression, List<CaseGroupTree> cases) {
        super(astNode);
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.cases = (List)Preconditions.checkNotNull(cases);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SWITCH_STATEMENT;
    }

    @Override
    public SyntaxToken switchKeyword() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaKeyword.SWITCH}).getToken());
    }

    @Override
    public SyntaxToken openParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION}).getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}).getToken());
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION}).getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}).getToken());
    }

    @Override
    public SyntaxToken openBraceToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.LWING}).getToken());
    }

    @Override
    public List<CaseGroupTree> cases() {
        return this.cases;
    }

    @Override
    public SyntaxToken closeBraceToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.RWING}).getToken());
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSwitchStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.expression), this.cases.iterator());
    }
}

