/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class TryStatementTreeImpl
extends JavaTree
implements TryStatementTree {
    private final List<VariableTree> resources;
    private final BlockTree block;
    private final List<CatchTree> catches;
    @Nullable
    private final BlockTree finallyBlock;

    public TryStatementTreeImpl(AstNode astNode, List<VariableTree> resources, BlockTree block, List<CatchTree> catches, @Nullable BlockTree finallyBlock) {
        super(astNode);
        this.resources = (List)Preconditions.checkNotNull(resources);
        this.block = (BlockTree)Preconditions.checkNotNull((Object)block);
        this.catches = (List)Preconditions.checkNotNull(catches);
        this.finallyBlock = finallyBlock;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TRY_STATEMENT;
    }

    @Override
    public SyntaxToken tryKeyword() {
        if (!this.resources.isEmpty()) {
            return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.TRY_WITH_RESOURCES_STATEMENT}).getFirstChild(new AstNodeType[]{JavaKeyword.TRY}).getToken());
        }
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaKeyword.TRY}).getToken());
    }

    @Override
    @Nullable
    public SyntaxToken openParenToken() {
        if (!this.resources.isEmpty()) {
            return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.RESOURCE_SPECIFICATION}).getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}).getToken());
        }
        return null;
    }

    @Override
    public List<VariableTree> resources() {
        return this.resources;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenToken() {
        if (!this.resources.isEmpty()) {
            return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.RESOURCE_SPECIFICATION}).getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}).getToken());
        }
        return null;
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    public List<CatchTree> catches() {
        return this.catches;
    }

    @Override
    @Nullable
    public SyntaxToken finallyKeyword() {
        AstNode node = this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.FINALLY_});
        return node == null ? null : new InternalSyntaxToken(node.getFirstChild(new AstNodeType[]{JavaKeyword.FINALLY}).getToken());
    }

    @Override
    @Nullable
    public BlockTree finallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTryStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.resources.iterator(), (Iterator)Iterators.singletonIterator((Object)this.block), this.catches.iterator(), (Iterator)Iterators.singletonIterator((Object)this.finallyBlock));
    }
}

