/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class WhileStatementTreeImpl
extends JavaTree
implements WhileStatementTree {
    private final ExpressionTree condition;
    private final StatementTree statement;

    public WhileStatementTreeImpl(AstNode astNode, ExpressionTree condition, StatementTree statement) {
        super(astNode);
        this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.WHILE_STATEMENT;
    }

    @Override
    public SyntaxToken whileKeyword() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaKeyword.WHILE}).getToken());
    }

    @Override
    public SyntaxToken openParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION}).getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}).getToken());
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION}).getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}).getToken());
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitWhileStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.statement});
    }
}

