/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.java.resolve.Symbol;

public class Type {
    public static final int BYTE = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BOOLEAN = 8;
    public static final int VOID = 9;
    public static final int CLASS = 10;
    public static final int ARRAY = 11;
    public static final int METHOD = 12;
    public static final int BOT = 13;
    public static final int UNKNOWN = 14;
    int tag;
    Symbol.TypeSymbol symbol;

    public Type(int tag, Symbol.TypeSymbol symbol) {
        this.tag = tag;
        this.symbol = symbol;
    }

    public boolean isTagged(int tag) {
        return tag == this.tag;
    }

    public boolean isNumerical() {
        return this.tag <= 7;
    }

    public String toString() {
        return this.symbol == null ? "" : this.symbol.toString();
    }

    public static class MethodType
    extends Type {
        List<Type> argTypes;
        @Nullable
        Type resultType;
        List<Type> thrown;

        public MethodType(List<Type> argTypes, @Nullable Type resultType, List<Type> thrown, Symbol.TypeSymbol symbol) {
            super(12, symbol);
            this.argTypes = argTypes;
            this.resultType = resultType;
            this.thrown = thrown;
        }

        @Override
        public String toString() {
            return this.resultType == null ? "constructor" : "returns " + this.resultType.toString();
        }
    }

    public static class ArrayType
    extends Type {
        Type elementType;

        public ArrayType(Type elementType, Symbol.TypeSymbol arrayClass) {
            super(11, arrayClass);
            this.elementType = elementType;
        }

        public int hashCode() {
            return new HashCodeBuilder(31, 37).append((Object)this.elementType).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ArrayType)) {
                return false;
            }
            ArrayType rhs = (ArrayType)obj;
            return new EqualsBuilder().append((Object)this.elementType, (Object)rhs.elementType).isEquals();
        }

        @Override
        public String toString() {
            return this.elementType.toString() + "[]";
        }

        public Type elementType() {
            return this.elementType;
        }
    }

    public static class ClassType
    extends Type {
        Type supertype;
        List<Type> interfaces;

        public ClassType(Symbol.TypeSymbol symbol) {
            super(10, symbol);
        }

        public Symbol.TypeSymbol getSymbol() {
            return this.symbol;
        }
    }
}

