/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.FormalParametersListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class MethodTreeImpl
extends JavaTree
implements MethodTree {
    private ModifiersTree modifiers;
    private List<TypeParameterTree> typeParameters;
    @Nullable
    private Tree returnType;
    private IdentifierTree simpleName;
    private final FormalParametersListTreeImpl parameters;
    @Nullable
    private final BlockTree block;
    private final List<ExpressionTree> throwsClauses;
    private final SyntaxToken defaultToken;
    private final ExpressionTree defaultValue;
    private Symbol.MethodSymbol symbol;

    public MethodTreeImpl(FormalParametersListTreeImpl parameters, @Nullable SyntaxToken defaultToken, @Nullable ExpressionTree defaultValue) {
        super(Tree.Kind.METHOD);
        this.typeParameters = ImmutableList.of();
        this.parameters = parameters;
        this.block = null;
        this.throwsClauses = ImmutableList.of();
        this.defaultToken = defaultToken;
        this.defaultValue = defaultValue;
        this.addChild(parameters);
        if (defaultToken != null) {
            this.addChild((AstNode)defaultToken);
        }
        if (defaultValue != null) {
            this.addChild((AstNode)defaultValue);
        }
    }

    public MethodTreeImpl(@Nullable Tree returnType, IdentifierTree simpleName, FormalParametersListTreeImpl parameters, List<ExpressionTree> throwsClauses, @Nullable BlockTree block) {
        super(returnType == null ? Tree.Kind.CONSTRUCTOR : Tree.Kind.METHOD);
        this.typeParameters = ImmutableList.of();
        this.modifiers = null;
        this.returnType = returnType;
        this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
        this.parameters = (FormalParametersListTreeImpl)Preconditions.checkNotNull((Object)parameters);
        this.block = block;
        this.throwsClauses = (List)Preconditions.checkNotNull(throwsClauses);
        this.defaultToken = null;
        this.defaultValue = null;
    }

    public MethodTreeImpl(AstNode astNode, ModifiersTree modifiers, List<TypeParameterTree> typeParameters, @Nullable Tree returnType, IdentifierTree simpleName, FormalParametersListTreeImpl parameters, @Nullable BlockTree block, List<ExpressionTree> throwsClauses, @Nullable ExpressionTree defaultValue) {
        super(astNode);
        this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
        this.typeParameters = (List)Preconditions.checkNotNull(typeParameters);
        this.returnType = returnType;
        this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
        this.parameters = (FormalParametersListTreeImpl)Preconditions.checkNotNull((Object)parameters);
        this.block = block;
        this.throwsClauses = (List)Preconditions.checkNotNull(throwsClauses);
        this.defaultToken = null;
        this.defaultValue = defaultValue;
    }

    public MethodTreeImpl complete(Tree returnType, IdentifierTree simpleName) {
        Preconditions.checkState((this.simpleName == null ? 1 : 0) != 0);
        this.returnType = returnType;
        this.simpleName = simpleName;
        this.prependChildren((AstNode)returnType, (AstNode)simpleName);
        return this;
    }

    public MethodTreeImpl completeWithTypeParameters(TypeParameterListTreeImpl typeParameters) {
        this.typeParameters = (List)Preconditions.checkNotNull((Object)typeParameters);
        return this;
    }

    public MethodTreeImpl completeWithModifiers(ModifiersTreeImpl modifiers) {
        Preconditions.checkState((this.modifiers == null ? 1 : 0) != 0);
        this.modifiers = modifiers;
        this.prependChildren(new AstNode[]{modifiers});
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return this.returnType == null ? Tree.Kind.CONSTRUCTOR : Tree.Kind.METHOD;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    public List<TypeParameterTree> typeParameters() {
        return this.typeParameters;
    }

    @Override
    @Nullable
    public Tree returnType() {
        return this.returnType;
    }

    @Override
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    public List<VariableTree> parameters() {
        return this.parameters;
    }

    @Override
    public List<ExpressionTree> throwsClauses() {
        return this.throwsClauses;
    }

    @Override
    @Nullable
    public BlockTree block() {
        return this.block;
    }

    @Override
    @Nullable
    public SyntaxToken defaultToken() {
        return this.defaultToken;
    }

    @Override
    @Nullable
    public ExpressionTree defaultValue() {
        return this.defaultValue;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethod(this);
    }

    public Symbol.MethodSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol.MethodSymbol symbol) {
        Preconditions.checkState((this.symbol == null ? 1 : 0) != 0);
        this.symbol = symbol;
    }

    @Override
    public int getLine() {
        return this.parameters.openParenToken().getLine();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator[])new Iterator[]{Iterators.singletonIterator((Object)this.modifiers), this.typeParameters.iterator(), Iterators.forArray((Object[])new Tree[]{this.returnType, this.simpleName}), this.parameters.iterator(), Iterators.singletonIterator((Object)this.block), this.throwsClauses.iterator(), Iterators.singletonIterator((Object)this.defaultValue)});
    }

    public Boolean isOverriding() {
        if (this.isStatic() || this.isPrivate()) {
            return false;
        }
        if (this.isAnnotatedOverride()) {
            return true;
        }
        if (this.symbol == null) {
            return null;
        }
        return this.symbol.isOverriden();
    }

    private boolean isStatic() {
        return this.modifiers.modifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isPrivate() {
        return this.modifiers.modifiers().contains((Object)Modifier.PRIVATE);
    }

    private boolean isPublic() {
        return this.modifiers.modifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isAnnotatedOverride() {
        for (AnnotationTree annotationTree : this.modifiers.annotations()) {
            if (!annotationTree.annotationType().is(Tree.Kind.IDENTIFIER)) continue;
            IdentifierTree identifier = (IdentifierTree)annotationTree.annotationType();
            if (!Override.class.getSimpleName().equals(identifier.name())) continue;
            return true;
        }
        return false;
    }

    public boolean isMainMethod() {
        return this.isPublicStatic() && this.isNamed("main") && this.returnsVoid() && this.hasStringArrayParameter();
    }

    private boolean isPublicStatic() {
        return this.isStatic() && this.isPublic();
    }

    private boolean hasStringArrayParameter() {
        return this.parameters.size() == 1 && this.isParameterStringArray();
    }

    private boolean isParameterStringArray() {
        VariableTree variableTree = (VariableTree)this.parameters.get(0);
        boolean result = false;
        if (variableTree.type().is(Tree.Kind.ARRAY_TYPE)) {
            ArrayTypeTree arrayTypeTree = (ArrayTypeTree)variableTree.type();
            Type arrayType = ((AbstractTypedTree)arrayTypeTree.type()).getSymbolType();
            result = arrayType.isTagged(10) && "String".equals(((Type.ClassType)arrayType).getSymbol().getName());
        }
        return result;
    }

    private boolean returnsVoid() {
        if (this.returnType != null) {
            return this.returnType.is(Tree.Kind.PRIMITIVE_TYPE) && "void".equals(((PrimitiveTypeTree)this.returnType).keyword().text());
        }
        return false;
    }

    private boolean isNamed(String name) {
        return name.equals(this.simpleName().name());
    }
}

