/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Type;

public class Symbol {
    public static final int PCK = 1;
    public static final int TYP = 2;
    public static final int VAR = 4;
    public static final int MTH = 16;
    public static final int ERRONEOUS = 64;
    public static final int AMBIGUOUS = 65;
    public static final int ABSENT = 66;
    final int kind;
    int flags;
    String name;
    Symbol owner;
    Completer completer;
    Type type;
    boolean isParametrized = false;

    public Symbol(int kind, int flags, @Nullable String name, @Nullable Symbol owner) {
        this.kind = kind;
        this.flags = flags;
        this.name = name;
        this.owner = owner;
    }

    public int flags() {
        return this.flags;
    }

    public Symbol owner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public void complete() {
        if (this.completer != null) {
            Completer c = this.completer;
            this.completer = null;
            c.complete(this);
        }
    }

    public TypeSymbol outermostClass() {
        Symbol symbol = this;
        Symbol result = null;
        while (symbol.kind != 1) {
            result = symbol;
            symbol = symbol.owner();
        }
        return (TypeSymbol)result;
    }

    public PackageSymbol packge() {
        Symbol result = this;
        while (result.kind != 1) {
            result = result.owner();
        }
        return (PackageSymbol)result;
    }

    public TypeSymbol enclosingClass() {
        Symbol result = this;
        while (result != null && result.kind != 2) {
            result = result.owner;
        }
        return (TypeSymbol)result;
    }

    public boolean isKind(int kind) {
        return (this.kind & kind) != 0;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isStatic() {
        return this.isFlag(8);
    }

    public boolean isFinal() {
        return this.isFlag(16);
    }

    public boolean isEnum() {
        return this.isFlag(16384);
    }

    public boolean isAbstract() {
        return this.isFlag(1024);
    }

    public boolean isPublic() {
        return this.isFlag(1);
    }

    public boolean isPrivate() {
        return this.isFlag(2);
    }

    public boolean isDeprecated() {
        return this.isFlag(131072);
    }

    private boolean isFlag(int flag) {
        this.complete();
        return (this.flags & flag) != 0;
    }

    public boolean isPackageVisibility() {
        this.complete();
        return (this.flags & 7) == 0;
    }

    public static class MethodSymbol
    extends Symbol {
        TypeSymbol type;
        Scope parameters;
        List<TypeSymbol> thrown;

        public MethodSymbol(int flags, String name, Type type, Symbol owner) {
            super(16, flags, name, owner);
            ((Symbol)this).type = type;
            this.type = ((Type.MethodType)type).resultType.symbol;
        }

        public MethodSymbol(int flags, String name, Symbol owner) {
            super(16, flags, name, owner);
        }

        public TypeSymbol getReturnType() {
            return this.type;
        }

        public List<TypeSymbol> getThrownTypes() {
            return this.thrown;
        }

        public List<Type> getParametersTypes() {
            Preconditions.checkState((((Symbol)this).type != null ? 1 : 0) != 0);
            return ((Type.MethodType)((Symbol)this).type).argTypes;
        }

        public void setMethodType(Type.MethodType methodType) {
            ((Symbol)this).type = methodType;
            if (methodType.resultType != null) {
                this.type = methodType.resultType.symbol;
            }
        }

        public Boolean isOverriden() {
            Boolean result = false;
            TypeSymbol enclosingClass = this.enclosingClass();
            if (StringUtils.isEmpty((String)enclosingClass.getName())) {
                return null;
            }
            for (Type.ClassType superType : enclosingClass.superTypes()) {
                Boolean overrideFromType = this.overridesFromSymbol(superType);
                if (overrideFromType == null) {
                    result = null;
                    continue;
                }
                if (!BooleanUtils.isTrue((Boolean)overrideFromType)) continue;
                return true;
            }
            return result;
        }

        private Boolean overridesFromSymbol(Type.ClassType classType) {
            Boolean result = false;
            if (classType.isTagged(14)) {
                return null;
            }
            List<Symbol> symbols = classType.getSymbol().members().lookup(this.name);
            for (Symbol overrideSymbol : symbols) {
                if (!overrideSymbol.isKind(16) || !this.canOverride((MethodSymbol)overrideSymbol)) continue;
                Boolean isOverriding = this.isOverriding((MethodSymbol)overrideSymbol);
                if (isOverriding == null) {
                    result = null;
                    continue;
                }
                if (!BooleanUtils.isTrue((Boolean)isOverriding)) continue;
                return true;
            }
            return result;
        }

        private boolean canOverride(MethodSymbol overridee) {
            if (overridee.isPackageVisibility()) {
                return overridee.outermostClass().owner().equals(this.outermostClass().owner());
            }
            return !overridee.isPrivate();
        }

        private Boolean isOverriding(MethodSymbol overridee) {
            if (this.getParametersTypes().size() != overridee.getParametersTypes().size()) {
                return false;
            }
            for (int i = 0; i < this.getParametersTypes().size(); ++i) {
                Type paramOverrider = this.getParametersTypes().get(i);
                if (paramOverrider.isTagged(14)) {
                    return null;
                }
                if (paramOverrider.equals(overridee.getParametersTypes().get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class VariableSymbol
    extends Symbol {
        public VariableSymbol(int flags, String name, Symbol owner) {
            super(4, flags, name, owner);
        }

        public VariableSymbol(int flags, String name, Type type, Symbol owner) {
            super(4, flags, name, owner);
            this.type = type;
        }

        public String type() {
            return this.type.symbol.name;
        }
    }

    public static class TypeSymbol
    extends Symbol {
        Scope members;

        public TypeSymbol(int flags, String name, Symbol owner) {
            super(2, flags, name, owner);
            this.type = new Type.ClassType(this);
        }

        public Type getSuperclass() {
            this.complete();
            return ((Type.ClassType)this.type).supertype;
        }

        public List<Type> getInterfaces() {
            this.complete();
            return ((Type.ClassType)this.type).interfaces;
        }

        public Scope members() {
            this.complete();
            return this.members;
        }

        public Set<Type.ClassType> superTypes() {
            ImmutableSet.Builder types = ImmutableSet.builder();
            Type.ClassType superClassType = (Type.ClassType)this.getSuperclass();
            types.addAll(this.interfacesOfType());
            while (superClassType != null) {
                types.add((Object)superClassType);
                TypeSymbol superClassSymbol = superClassType.getSymbol();
                types.addAll(superClassSymbol.interfacesOfType());
                superClassType = (Type.ClassType)superClassSymbol.getSuperclass();
            }
            return types.build();
        }

        private Set<Type.ClassType> interfacesOfType() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Type interfaceType : this.getInterfaces()) {
                Type.ClassType classType = (Type.ClassType)interfaceType;
                builder.add((Object)classType);
                builder.addAll(classType.getSymbol().interfacesOfType());
            }
            return builder.build();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class PackageSymbol
    extends Symbol {
        Scope members;

        public PackageSymbol(@Nullable String name, @Nullable Symbol owner) {
            super(1, 0, name, owner);
        }

        Scope members() {
            this.complete();
            return this.members;
        }
    }

    static interface Completer {
        public void complete(Symbol var1);
    }
}

