/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public class TypeAndReferenceSolver
extends BaseTreeVisitor {
    private final Map<Tree.Kind, Type> typesOfLiterals = Maps.newEnumMap(Tree.Kind.class);
    private final SemanticModel semanticModel;
    private final Symbols symbols;
    private final Resolve resolve;
    private final Map<Tree, Type> types = Maps.newHashMap();
    Resolve.Env env;

    public TypeAndReferenceSolver(SemanticModel semanticModel, Symbols symbols, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.symbols = symbols;
        this.resolve = resolve;
        this.typesOfLiterals.put(Tree.Kind.BOOLEAN_LITERAL, symbols.booleanType);
        this.typesOfLiterals.put(Tree.Kind.NULL_LITERAL, symbols.nullType);
        this.typesOfLiterals.put(Tree.Kind.CHAR_LITERAL, symbols.charType);
        this.typesOfLiterals.put(Tree.Kind.STRING_LITERAL, symbols.stringType);
        this.typesOfLiterals.put(Tree.Kind.FLOAT_LITERAL, symbols.floatType);
        this.typesOfLiterals.put(Tree.Kind.DOUBLE_LITERAL, symbols.doubleType);
        this.typesOfLiterals.put(Tree.Kind.LONG_LITERAL, symbols.longType);
        this.typesOfLiterals.put(Tree.Kind.INT_LITERAL, symbols.intType);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.scan(tree.modifiers());
        this.scan(tree.typeParameters());
        this.scan(tree.defaultValue());
        this.scan(tree.block());
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.scan(tree.modifiers());
        this.scan(tree.typeParameters());
        this.scan(tree.members());
    }

    @Override
    public void visitImport(ImportTree tree) {
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        super.visitExpressionStatement(tree);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        IdentifierTree identifier;
        Type type;
        ExpressionTree methodSelect = tree.methodSelect();
        Resolve.Env methodEnv = this.semanticModel.getEnv(tree);
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)methodSelect;
            this.resolveAs(mset.expression(), 6);
            type = this.getType(mset.expression());
            identifier = mset.identifier();
        } else if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            type = methodEnv.enclosingClass.type;
            identifier = (IdentifierTree)methodSelect;
        } else {
            throw new IllegalStateException("Method select in method invocation is not of the expected type " + methodSelect);
        }
        this.scan(tree.arguments());
        String name = identifier.name();
        if (type == null) {
            type = this.symbols.unknownType;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ExpressionTree expressionTree : tree.arguments()) {
            Type symbolType = ((AbstractTypedTree)((Object)expressionTree)).getSymbolType();
            if (symbolType == null) {
                symbolType = this.symbols.unknownType;
            }
            builder.add((Object)symbolType);
        }
        Symbol symbol = this.resolve.findMethod(methodEnv, type.symbol, name, (List<Type>)builder.build());
        this.associateReference(identifier, symbol);
        type = this.getTypeOfSymbol(symbol);
        if (type == null || symbol.kind >= 64) {
            this.registerType(tree, this.symbols.unknownType);
        } else {
            this.registerType(tree, ((Type.MethodType)type).resultType);
        }
    }

    private void resolveAs(@Nullable Tree tree, int kind) {
        if (tree == null) {
            return;
        }
        if (this.env == null) {
            this.resolveAs(tree, kind, this.semanticModel.getEnv(tree));
        } else {
            this.resolveAs(tree, kind, this.env);
        }
    }

    public Symbol resolveAs(Tree tree, int kind, Resolve.Env resolveEnv) {
        if (tree.is(Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT)) {
            Symbol resolvedSymbol;
            IdentifierTree identifierTree;
            if (tree.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
                if (JavaKeyword.CLASS.getValue().equals(mse.identifier().name())) {
                    this.registerType(tree, this.symbols.classType);
                    return null;
                }
                identifierTree = mse.identifier();
                resolvedSymbol = this.getSymbolOfMemberSelectExpression(mse, kind, resolveEnv);
                this.registerType(identifierTree, this.getTypeOfSymbol(resolvedSymbol));
            } else {
                identifierTree = (IdentifierTree)tree;
                resolvedSymbol = this.resolve.findIdent(resolveEnv, identifierTree.name(), kind);
            }
            this.associateReference(identifierTree, resolvedSymbol);
            this.registerType(tree, this.getTypeOfSymbol(resolvedSymbol));
            return resolvedSymbol;
        }
        tree.accept(this);
        Type type = this.getType(tree);
        if (tree.is(Tree.Kind.INFERED_TYPE)) {
            return null;
        }
        if (type == null) {
            throw new IllegalStateException("Type not resolved " + tree);
        }
        return type.symbol;
    }

    private Symbol getSymbolOfMemberSelectExpression(MemberSelectExpressionTree mse, int kind, Resolve.Env resolveEnv) {
        int expressionKind = 2;
        if ((kind & 4) != 0) {
            expressionKind |= 4;
        }
        if ((kind & 2) != 0) {
            expressionKind |= 1;
        }
        Symbol site = this.resolveAs(mse.expression(), expressionKind, resolveEnv);
        if (site.kind == 4) {
            return this.resolve.findIdentInType(resolveEnv, site.type.symbol, mse.identifier().name(), 4);
        }
        if (site.kind == 2) {
            return this.resolve.findIdentInType(resolveEnv, (Symbol.TypeSymbol)site, mse.identifier().name(), kind);
        }
        if (site.kind == 1) {
            return this.resolve.findIdentInPackage(site, mse.identifier().name(), kind);
        }
        return this.symbols.unknownSymbol;
    }

    private void resolveAs(List<? extends Tree> trees, int kind) {
        for (Tree tree : trees) {
            this.resolveAs(tree, kind);
        }
    }

    @Override
    public void visitTypeArguments(TypeArgumentListTreeImpl trees) {
        this.resolveAs(trees, 2);
    }

    @Override
    public void visitInstanceOf(InstanceOfTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.resolveAs(tree.type(), 2);
        this.registerType(tree, this.symbols.booleanType);
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        this.resolveAs(tree.type(), 2);
        this.resolveAs(tree.typeArguments(), 2);
        this.registerType(tree, this.getType(tree.type()));
    }

    @Override
    public void visitWildcard(WildcardTree tree) {
        if (tree.bound() == null) {
            this.registerType(tree, this.symbols.unknownType);
        } else {
            this.resolveAs(tree.bound(), 2);
            this.registerType(tree, this.getType(tree.bound()));
        }
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.resolveAs(tree.condition(), 4);
        this.resolveAs(tree.trueExpression(), 4);
        this.resolveAs(tree.falseExpression(), 4);
        this.registerType(tree, this.symbols.unknownType);
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.resolveAs(tree.expression(), 4);
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree tree) {
        super.visitLambdaExpression(tree);
        this.registerType(tree, this.symbols.unknownType);
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        this.resolveAs(tree.type(), 2);
        this.resolveAs(tree.dimensions(), 4);
        this.resolveAs(tree.initializers(), 4);
        Type type = this.getType(tree.type());
        int dimensions = tree.dimensions().size();
        type = new Type.ArrayType(type, this.symbols.arrayClass);
        for (int i = 1; i < dimensions; ++i) {
            type = new Type.ArrayType(type, this.symbols.arrayClass);
        }
        this.registerType(tree, type);
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.resolveAs(tree.index(), 4);
        Type type = this.getType(tree.expression());
        if (type != null && type.tag == 11) {
            this.registerType(tree, ((Type.ArrayType)type).elementType);
        } else {
            this.registerType(tree, this.symbols.unknownType);
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        this.resolveAs(tree.leftOperand(), 4);
        this.resolveAs(tree.rightOperand(), 4);
        Type left = this.getType(tree.leftOperand());
        Type right = this.getType(tree.rightOperand());
        if (left == null || right == null) {
            this.registerType(tree, this.symbols.unknownType);
            return;
        }
        Symbol symbol = this.resolve.findMethod(this.semanticModel.getEnv(tree), tree.operatorToken().text(), (List<Type>)ImmutableList.of((Object)left, (Object)right));
        if (symbol.kind != 16) {
            this.registerType(tree, this.symbols.unknownType);
            return;
        }
        this.registerType(tree, ((Type.MethodType)symbol.type).resultType);
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        if (tree.enclosingExpression() != null) {
            this.resolveAs(tree.enclosingExpression(), 4);
        }
        this.resolveAs(tree.identifier(), 2);
        this.resolveAs(tree.typeArguments(), 2);
        this.resolveAs(tree.arguments(), 4);
        if (tree.classBody() != null) {
            this.scan(tree.classBody());
            this.registerType(tree, this.symbols.unknownType);
        } else {
            this.registerType(tree, this.getType(tree.identifier()));
        }
    }

    @Override
    public void visitPrimitiveType(PrimitiveTypeTree tree) {
        Type type = this.env == null ? this.resolve.findIdent((Resolve.Env)this.semanticModel.getEnv((Tree)tree), (String)tree.keyword().text(), (int)2).type : this.resolve.findIdent((Resolve.Env)this.env, (String)tree.keyword().text(), (int)2).type;
        this.registerType(tree, type);
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.scan(tree.modifiers());
        if (tree.initializer() != null) {
            this.resolveAs(tree.initializer(), 4);
        }
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.resolveAs(tree.variable(), 4);
        this.resolveAs(tree.expression(), 4);
        Type type = this.getType(tree.variable());
        this.registerType(tree, type);
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        Type type = this.typesOfLiterals.get((Object)((JavaTree)((Object)tree)).getKind());
        this.registerType(tree, type);
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        if (this.getType(tree.type()) == null) {
            this.resolveAs(tree.type(), 2);
        }
        this.registerType(tree, new Type.ArrayType(this.getType(tree.type()), this.symbols.arrayClass));
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        this.resolveAs(tree.type(), 2);
        this.resolveAs(tree.expression(), 4);
        this.registerType(tree, this.getType(tree.type()));
    }

    @Override
    public void visitUnionType(UnionTypeTree tree) {
        this.resolveAs(tree.typeAlternatives(), 2);
        this.registerType(tree, this.symbols.unknownType);
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.scan(tree.modifiers());
        NewClassTree newClassTree = (NewClassTree)tree.initializer();
        this.scan(newClassTree.enclosingExpression());
        this.scan(newClassTree.typeArguments());
        this.scan(newClassTree.arguments());
        this.scan(newClassTree.classBody());
    }

    @Override
    public void visitAnnotation(AnnotationTree tree) {
        this.resolveAs(tree.annotationType(), 2);
        for (ExpressionTree expressionTree : tree.arguments()) {
            this.resolveAs(expressionTree, 4);
        }
        this.registerType(tree, this.getType(tree.annotationType()));
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (((AbstractTypedTree)((Object)tree)).getSymbolType() == null) {
            this.resolveAs(tree, 4);
        }
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        if (((AbstractTypedTree)((Object)tree)).getSymbolType() == null) {
            this.resolveAs(tree, 4);
        }
    }

    @Override
    public void visitOther(Tree tree) {
        this.registerType(tree, this.symbols.unknownType);
    }

    private Type getTypeOfSymbol(Symbol symbol) {
        if (symbol.kind < 64) {
            return symbol.type;
        }
        return this.symbols.unknownType;
    }

    @VisibleForTesting
    Type getType(Tree tree) {
        return this.types.get(tree);
    }

    private void registerType(Tree tree, Type type) {
        if (AbstractTypedTree.class.isAssignableFrom(tree.getClass())) {
            ((AbstractTypedTree)tree).setType(type);
        }
        this.types.put(tree, type);
    }

    private void associateReference(IdentifierTree tree, Symbol symbol) {
        if (symbol.kind < 64) {
            this.semanticModel.associateReference(tree, symbol);
        }
    }
}

