/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

public class LiteralUtils {
    private LiteralUtils() {
    }

    @CheckForNull
    public static Integer intLiteralValue(ExpressionTree expression) {
        if (expression.is(Tree.Kind.INT_LITERAL)) {
            return LiteralUtils.intLiteralValue((LiteralTree)expression);
        }
        if (expression.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
            UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
            Integer subExpressionIntValue = LiteralUtils.intLiteralValue(unaryExp.expression());
            return expression.is(Tree.Kind.UNARY_MINUS) ? LiteralUtils.minus(subExpressionIntValue) : subExpressionIntValue;
        }
        return null;
    }

    @CheckForNull
    private static Integer intLiteralValue(LiteralTree literal) {
        String literalValue = literal.value();
        if (literalValue.startsWith("0x") || literalValue.startsWith("0b")) {
            return null;
        }
        return Integer.valueOf(literalValue);
    }

    @CheckForNull
    private static Integer minus(@Nullable Integer nullableInteger) {
        return nullableInteger == null ? null : Integer.valueOf(-nullableInteger.intValue());
    }

    public static String trimQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

