/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.ast.AstScanner;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.ast.visitors.CommentLinesVisitor;
import org.sonar.java.ast.visitors.FileVisitor;
import org.sonar.java.parser.sslr.ActionParser2;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.metrics.CommentsVisitor;
import org.sonar.sslr.parser.LexerlessGrammar;

public final class JavaAstScanner {
    private JavaAstScanner() {
    }

    @VisibleForTesting
    public static SourceFile scanSingleFile(File file, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        return JavaAstScanner.scanSingleFile(file, file.getParentFile(), visitors);
    }

    @VisibleForTesting
    public static SourceFile scanSingleFile(File file, File parentFile, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner scanner = JavaAstScanner.create(new JavaConfiguration(Charset.forName("UTF-8")), visitors);
        scanner.scan(Collections.singleton(file));
        Collection sources = scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner create(JavaConfiguration conf, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        ActionParser2 parser = JavaParser.createParser(conf.getCharset());
        AstScanner builder = new AstScanner(parser);
        builder.withSquidAstVisitor(new FileVisitor());
        builder.setCommentAnalyser(new CommentLinesVisitor.JavaCommentAnalyser());
        builder.withSquidAstVisitor((SquidAstVisitor<LexerlessGrammar>)CommentsVisitor.builder().withNoSonar(true).withIgnoreHeaderComment(true).build());
        for (SquidAstVisitor<LexerlessGrammar> visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)visitor).setCharset(conf.getCharset());
            }
            builder.withSquidAstVisitor(visitor);
        }
        return builder;
    }
}

