/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.java.ast.parser.ListTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ModifiersTreeImpl
extends ListTreeImpl<ModifierTree>
implements ModifiersTree {
    public static final ModifiersTreeImpl EMPTY = new ModifiersTreeImpl();
    private final List<Modifier> modifiers;
    private final List<AnnotationTree> annotations;

    public static final ModifiersTreeImpl emptyModifiers() {
        return new ModifiersTreeImpl((List<ModifierTree>)ImmutableList.of());
    }

    private ModifiersTreeImpl() {
        super((AstNode)null);
        this.annotations = Lists.newArrayList();
        this.modifiers = Lists.newArrayList();
    }

    public ModifiersTreeImpl(List<ModifierTree> javaTrees) {
        super((AstNodeType)JavaLexer.MODIFIERS, javaTrees, (List<AstNode>)ImmutableList.of());
        ImmutableList.Builder modifierBuilder = ImmutableList.builder();
        ImmutableList.Builder annotationBuilder = ImmutableList.builder();
        for (ModifierTree modifierTree : this) {
            if (modifierTree.is(Tree.Kind.ANNOTATION)) {
                annotationBuilder.add((Object)((AnnotationTree)modifierTree));
            } else {
                ModifierKeywordTree modifierKeywordTree = (ModifierKeywordTree)modifierTree;
                modifierBuilder.add((Object)modifierKeywordTree.modifier());
            }
            this.addChild((AstNode)modifierTree);
        }
        this.annotations = annotationBuilder.build();
        this.modifiers = modifierBuilder.build();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.MODIFIERS;
    }

    @Override
    public List<Modifier> modifiers() {
        return this.modifiers;
    }

    @Override
    public List<AnnotationTree> annotations() {
        return this.annotations;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitModifier(this);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return ImmutableList.builder().addAll((Iterable)this).build().iterator();
    }
}

