/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.parser.sslr;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.java.parser.sslr.ActionParser2;
import org.sonar.java.parser.sslr.Input;
import org.sonar.java.parser.sslr.Optional;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.vm.TokenExpression;
import org.sonar.sslr.internal.vm.TriviaExpression;

public class SyntaxTreeCreator<T> {
    private static final TokenType UNDEFINED_TOKEN_TYPE = new TokenType(){

        public String getName() {
            return "TOKEN";
        }

        public String getValue() {
            return this.getName();
        }

        public boolean hasToBeSkippedFromAst(AstNode node) {
            return false;
        }

        public String toString() {
            return SyntaxTreeCreator.class.getSimpleName();
        }
    };
    private final Object treeFactory;
    private final ActionParser2.GrammarBuilderInterceptor mapping;
    private final Token.Builder tokenBuilder = Token.builder();
    private final List<Trivia> trivias = Lists.newArrayList();
    private Input input;

    public SyntaxTreeCreator(Object treeFactory, ActionParser2.GrammarBuilderInterceptor mapping) {
        this.treeFactory = treeFactory;
        this.mapping = mapping;
    }

    public T create(ParseNode node, Input input) {
        this.input = input;
        this.trivias.clear();
        return (T)this.visit(node);
    }

    private Object visit(ParseNode node) {
        if (node.getMatcher() instanceof MutableParsingRule) {
            return this.visitNonTerminal(node);
        }
        return this.visitTerminal(node);
    }

    private Object visitNonTerminal(ParseNode node) {
        MutableParsingRule rule = (MutableParsingRule)node.getMatcher();
        GrammarRuleKey ruleKey = rule.getRuleKey();
        if (this.mapping.hasMethodForRuleKey(ruleKey)) {
            Preconditions.checkState((node.getChildren().size() == 1 ? 1 : 0) != 0);
            return this.visit((ParseNode)node.getChildren().get(0));
        }
        if (this.mapping.isOptionalRule(ruleKey)) {
            Preconditions.checkState((node.getChildren().size() <= 1 ? 1 : 0) != 0);
            if (node.getChildren().isEmpty()) {
                return Optional.absent();
            }
            return Optional.of(this.visit((ParseNode)node.getChildren().get(0)));
        }
        List children = node.getChildren();
        ArrayList convertedChildren = Lists.newArrayList();
        for (ParseNode child : children) {
            Object result = this.visit(child);
            if (result == null) continue;
            convertedChildren.add(result);
        }
        if (this.mapping.isOneOrMoreRule(ruleKey)) {
            return Lists.newArrayList((Iterable)convertedChildren);
        }
        if (this.mapping.isZeroOrMoreRule(ruleKey)) {
            return convertedChildren.isEmpty() ? Optional.absent() : Optional.of(Lists.newArrayList((Iterable)convertedChildren));
        }
        Method method = this.mapping.actionForRuleKey(ruleKey);
        if (method == null) {
            Token token = null;
            for (Object child : convertedChildren) {
                if (!(child instanceof AstNode) || !((AstNode)child).hasToken()) continue;
                token = ((AstNode)child).getToken();
                break;
            }
            AstNode astNode = new AstNode(rule.getRealAstNodeType(), rule.getName(), token);
            for (Object child : convertedChildren) {
                astNode.addChild((AstNode)child);
            }
            astNode.setFromIndex(node.getStartIndex());
            astNode.setToIndex(node.getEndIndex());
            return astNode;
        }
        try {
            return method.invoke(this.treeFactory, convertedChildren.toArray(new Object[convertedChildren.size()]));
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private AstNode visitTerminal(ParseNode node) {
        if (node.getMatcher() instanceof TriviaExpression) {
            TriviaExpression ruleMatcher = (TriviaExpression)node.getMatcher();
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.SKIPPED_TEXT) {
                return null;
            }
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.COMMENT) {
                this.updateTokenPositionAndValue(node);
                this.tokenBuilder.setTrivia(Collections.emptyList());
                this.tokenBuilder.setType((TokenType)GenericTokenType.COMMENT);
                this.trivias.add(Trivia.createComment((Token)this.tokenBuilder.build()));
                return null;
            }
            throw new IllegalStateException("Unexpected trivia kind: " + ruleMatcher.getTriviaKind());
        }
        if (node.getMatcher() instanceof TokenExpression) {
            this.updateTokenPositionAndValue(node);
            TokenExpression ruleMatcher = (TokenExpression)node.getMatcher();
            this.tokenBuilder.setType(ruleMatcher.getTokenType());
            if (ruleMatcher.getTokenType() == GenericTokenType.COMMENT) {
                this.tokenBuilder.setTrivia(Collections.emptyList());
                this.trivias.add(Trivia.createComment((Token)this.tokenBuilder.build()));
                return null;
            }
        } else {
            this.updateTokenPositionAndValue(node);
            this.tokenBuilder.setType(UNDEFINED_TOKEN_TYPE);
        }
        Token token = this.tokenBuilder.setTrivia(this.trivias).build();
        this.trivias.clear();
        AstNode astNode = new AstNode(token);
        astNode.setFromIndex(node.getStartIndex());
        astNode.setToIndex(node.getEndIndex());
        return astNode;
    }

    private void updateTokenPositionAndValue(ParseNode node) {
        this.tokenBuilder.setGeneratedCode(false);
        int[] lineAndColumn = this.input.lineAndColumnAt(node.getStartIndex());
        this.tokenBuilder.setLine(lineAndColumn[0]);
        this.tokenBuilder.setColumn(lineAndColumn[1] - 1);
        this.tokenBuilder.setURI(this.input.uri());
        String value = this.input.substring(node.getStartIndex(), node.getEndIndex());
        this.tokenBuilder.setValueAndOriginalValue(value);
    }
}

