/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.java.AbstractJavaClasspath;

public class JavaClasspath
extends AbstractJavaClasspath {
    @Nullable
    private final MavenProject pom;
    private static final Logger LOG = LoggerFactory.getLogger(JavaClasspath.class);

    public JavaClasspath(Project project, Settings settings, FileSystem fs) {
        this(project, settings, fs, (MavenProject)null);
    }

    public JavaClasspath(Project project, Settings settings, FileSystem fs, @Nullable MavenProject pom) {
        super(project, settings, fs, InputFile.Type.MAIN);
        this.pom = pom;
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            boolean useDeprecatedProperties;
            this.initialized = true;
            this.validateLibraries = this.project.getModules().isEmpty();
            this.binaries = this.getFilesFromProperty("sonar.java.binaries");
            List<File> libraries = this.getFilesFromProperty("sonar.java.libraries");
            boolean bl = useDeprecatedProperties = this.binaries.isEmpty() && libraries.isEmpty();
            if (useDeprecatedProperties) {
                this.binaries = this.getFilesFromProperty("sonar.binaries");
                libraries = this.getFilesFromProperty("sonar.libraries");
            }
            if (this.pom != null && libraries.isEmpty()) {
                this.elements = this.getLibrariesFromMaven(this.pom);
            } else {
                this.elements = Lists.newArrayList((Iterable)this.binaries);
                this.elements.addAll(libraries);
                if (useDeprecatedProperties && !this.elements.isEmpty()) {
                    LOG.warn("sonar.binaries and sonar.libraries are deprecated since version 2.5 of sonar-java-plugin, please use sonar.java.binaries and sonar.java.libraries instead");
                }
            }
        }
    }

    private List<File> getLibrariesFromMaven(MavenProject pom) {
        try {
            File outputDirectoryFile;
            ArrayList files = Lists.newArrayList();
            if (pom.getCompileClasspathElements() != null) {
                for (String classPathString : pom.getCompileClasspathElements()) {
                    files.add(new File(classPathString));
                }
            }
            if (pom.getBuild().getOutputDirectory() != null && (outputDirectoryFile = new File(pom.getBuild().getOutputDirectory())).exists()) {
                files.add(outputDirectoryFile);
            }
            return files;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new SonarException("Fail to create the project classloader", (Throwable)e);
        }
    }
}

