/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.signature.MethodSignaturePrinter;
import org.sonar.java.signature.MethodSignatureScanner;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

public class JavaFilesCache
extends BaseTreeVisitor
implements JavaFileScanner {
    @VisibleForTesting
    Map<String, File> resourcesCache = Maps.newHashMap();
    @VisibleForTesting
    Map<String, Integer> methodStartLines = Maps.newHashMap();
    @VisibleForTesting
    Multimap<Integer, String> suppressWarningLines = HashMultimap.create();
    private File currentFile;
    private Deque<String> currentClassKey = new LinkedList<String>();
    private Deque<Tree> parent = new LinkedList<Tree>();
    private Deque<Integer> anonymousInnerClassCounter = new LinkedList<Integer>();
    private String currentPackage;

    public Map<String, File> getResourcesCache() {
        return this.resourcesCache;
    }

    public Map<String, Integer> getMethodStartLines() {
        return this.methodStartLines;
    }

    public Multimap<Integer, String> getSuppressWarningLines() {
        return this.suppressWarningLines;
    }

    public boolean hasSuppressWarningLines() {
        return !this.suppressWarningLines.isEmpty();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        JavaTree.CompilationUnitTreeImpl tree = (JavaTree.CompilationUnitTreeImpl)context.getTree();
        this.currentPackage = tree.packageNameAsString().replace('.', '/');
        this.currentFile = context.getFile();
        this.currentClassKey.clear();
        this.parent.clear();
        this.anonymousInnerClassCounter.clear();
        this.suppressWarningLines.clear();
        this.scan(tree);
    }

    @Override
    public void visitClass(ClassTree tree) {
        String className = "";
        if (tree.simpleName() != null) {
            className = tree.simpleName().name();
        }
        String key = this.getClassKey(className);
        this.currentClassKey.push(key);
        this.parent.push(tree);
        this.anonymousInnerClassCounter.push(0);
        this.resourcesCache.put(key, this.currentFile);
        this.handleSuppressWarning(tree);
        super.visitClass(tree);
        this.currentClassKey.pop();
        this.parent.pop();
        this.anonymousInnerClassCounter.pop();
    }

    private String getClassKey(String className) {
        String key = className;
        if (StringUtils.isNotEmpty((String)this.currentPackage)) {
            key = this.currentPackage + "/" + className;
        }
        if ("".equals(className) || this.parent.peek() != null && this.parent.peek().is(Tree.Kind.METHOD)) {
            int count = this.anonymousInnerClassCounter.pop() + 1;
            key = this.currentClassKey.peek() + "$" + count + className;
            this.anonymousInnerClassCounter.push(count);
        } else if (this.currentClassKey.peek() != null) {
            key = this.currentClassKey.peek() + "$" + className;
        }
        return key;
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.parent.push(tree);
        String methodKey = this.currentClassKey.peek() + "#" + MethodSignaturePrinter.print(MethodSignatureScanner.scan(tree));
        this.methodStartLines.put(methodKey, ((JavaTree)((Object)tree.simpleName())).getLine());
        this.handleSuppressWarning(tree);
        super.visitMethod(tree);
        this.parent.pop();
    }

    private void handleSuppressWarning(ClassTree tree) {
        int endLine = ((InternalSyntaxToken)tree.closeBraceToken()).getLine();
        this.handleSuppressWarning(tree.modifiers().annotations(), endLine);
    }

    private void handleSuppressWarning(MethodTree tree) {
        int endLine = ((JavaTree)((Object)tree.simpleName())).getLine();
        if (tree.block() != null) {
            endLine = ((InternalSyntaxToken)tree.block().closeBraceToken()).getLine();
        }
        this.handleSuppressWarning(tree.modifiers().annotations(), endLine);
    }

    private void handleSuppressWarning(List<AnnotationTree> annotationTrees, int endLine) {
        int startLine = 0;
        ArrayList warnings = Lists.newArrayList();
        for (AnnotationTree annotationTree : annotationTrees) {
            if (!this.isSuppressWarningsAnnotation(annotationTree)) continue;
            startLine = ((JavaTree)((Object)annotationTree)).getLine();
            warnings.addAll(this.getSuppressWarningArgs(annotationTree));
            break;
        }
        for (int i = startLine; i <= endLine; ++i) {
            this.suppressWarningLines.putAll((Object)i, (Iterable)warnings);
        }
    }

    private boolean isSuppressWarningsAnnotation(AnnotationTree annotationTree) {
        boolean suppressWarningsType = false;
        TypeTree type = annotationTree.annotationType();
        if (type.is(Tree.Kind.IDENTIFIER)) {
            suppressWarningsType = "SuppressWarnings".equals(((IdentifierTree)type).name());
        } else if (type.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)type;
            suppressWarningsType = "SuppressWarnings".equals(mset.identifier().name()) && mset.expression().is(Tree.Kind.MEMBER_SELECT) && "lang".equals(((MemberSelectExpressionTree)mset.expression()).identifier().name());
        }
        return suppressWarningsType;
    }

    private List<String> getSuppressWarningArgs(AnnotationTree annotationTree) {
        return this.getValueFromExpression(annotationTree.arguments().get(0));
    }

    private List<String> getValueFromExpression(ExpressionTree expression) {
        ArrayList args = Lists.newArrayList();
        if (expression.is(Tree.Kind.STRING_LITERAL)) {
            args.add(this.trimQuotes(((LiteralTree)expression).value()));
        } else if (expression.is(Tree.Kind.NEW_ARRAY)) {
            for (ExpressionTree initializer : ((NewArrayTree)expression).initializers()) {
                args.addAll(this.getValueFromExpression(initializer));
            }
        }
        return args;
    }

    private String trimQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

