/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.Token;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class SubscriptionVisitor
implements JavaFileScanner {
    protected JavaFileScannerContext context;
    private Collection<Tree.Kind> nodesToVisit;
    private SemanticModel semanticModel;

    public abstract List<Tree.Kind> nodesToVisit();

    public void visitNode(Tree tree) {
    }

    public void leaveNode(Tree tree) {
    }

    public void visitToken(SyntaxToken syntaxToken) {
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        this.scanTree(context.getTree());
        this.visitTokens(context.getTree());
    }

    protected void scanTree(Tree tree) {
        this.nodesToVisit = this.nodesToVisit();
        this.visit(tree);
    }

    protected void visitTokens(CompilationUnitTree compilationUnitTree) {
        if (this.nodesToVisit().contains((Object)Tree.Kind.TOKEN) || this.nodesToVisit().contains((Object)Tree.Kind.TRIVIA)) {
            for (Token token : ((JavaTree)((Object)compilationUnitTree)).getAstNode().getTokens()) {
                InternalSyntaxToken syntaxToken = new InternalSyntaxToken(token);
                this.visitToken(syntaxToken);
                if (!this.nodesToVisit().contains((Object)Tree.Kind.TRIVIA)) continue;
                for (SyntaxTrivia syntaxTrivia : syntaxToken.trivias()) {
                    this.visitTrivia(syntaxTrivia);
                }
            }
        }
    }

    private void visit(Tree tree) {
        boolean isSubscribed = this.isSubscribed(tree);
        if (isSubscribed) {
            this.visitNode(tree);
        }
        this.visitChildren(tree);
        if (isSubscribed) {
            this.leaveNode(tree);
        }
    }

    protected boolean isSubscribed(Tree tree) {
        return this.nodesToVisit.contains((Object)((JavaTree)tree).getKind());
    }

    private void visitChildren(Tree tree) {
        JavaTree javaTree = (JavaTree)tree;
        if (!javaTree.isLeaf()) {
            Iterator<Tree> iter = javaTree.childrenIterator();
            while (iter.hasNext()) {
                Tree next = iter.next();
                if (next == null) continue;
                this.visit(next);
            }
        }
    }

    public boolean hasSemantic() {
        return this.semanticModel != null;
    }
}

