/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeTree;

public class TypeCastExpressionTreeImpl
extends AbstractTypedTree
implements TypeCastTree {
    private InternalSyntaxToken openParenToken;
    private InternalSyntaxToken closeParenToken;
    private final TypeTree type;
    private final ExpressionTree expression;

    public TypeCastExpressionTreeImpl(TypeTree type, ExpressionTree expression, InternalSyntaxToken closeParenToken, List<AstNode> children) {
        super(Tree.Kind.TYPE_CAST);
        this.type = (TypeTree)Preconditions.checkNotNull((Object)type);
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.closeParenToken = closeParenToken;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public TypeCastExpressionTreeImpl complete(InternalSyntaxToken openParenToken) {
        Preconditions.checkState((this.openParenToken == null && this.closeParenToken != null ? 1 : 0) != 0);
        this.openParenToken = openParenToken;
        this.prependChildren(openParenToken);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TYPE_CAST;
    }

    @Override
    public SyntaxToken openParenToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}));
    }

    @Override
    public TypeTree type() {
        return this.type;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}));
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeCast(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.type, this.expression});
    }
}

