/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;

public class JavaType
implements Type {
    public static final int BYTE = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BOOLEAN = 8;
    public static final int VOID = 9;
    public static final int CLASS = 10;
    public static final int ARRAY = 11;
    public static final int METHOD = 12;
    public static final int BOT = 13;
    public static final int UNKNOWN = 14;
    public static final int TYPEVAR = 15;
    int tag;
    JavaType primitiveType = null;
    JavaType primitiveWrapperType = null;
    JavaSymbol.TypeJavaSymbol symbol;

    public JavaType(int tag, JavaSymbol.TypeJavaSymbol symbol) {
        this.tag = tag;
        this.symbol = symbol;
    }

    public boolean isTagged(int tag) {
        return tag == this.tag;
    }

    @Override
    public boolean isNumerical() {
        return this.tag <= 7;
    }

    public JavaSymbol.TypeJavaSymbol getSymbol() {
        this.symbol.complete();
        return this.symbol;
    }

    @Override
    public boolean is(String fullyQualifiedName) {
        if (this.tag < 10) {
            return fullyQualifiedName.equals(this.symbol.name);
        }
        if (this.isTagged(11)) {
            return fullyQualifiedName.endsWith("[]") && ((ArrayJavaType)this).elementType.is(fullyQualifiedName.substring(0, fullyQualifiedName.length() - 2));
        }
        if (this.isTagged(15)) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(String fullyQualifiedName) {
        if (this.isTagged(11)) {
            return "java.lang.Object".equals(fullyQualifiedName) || fullyQualifiedName.endsWith("[]") && ((ArrayJavaType)this).elementType.isSubtypeOf(fullyQualifiedName.substring(0, fullyQualifiedName.length() - 2));
        }
        if (this.isTagged(15)) {
            return this.erasure().isSubtypeOf(fullyQualifiedName);
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(Type superType) {
        JavaType supType = (JavaType)superType;
        if (this.isTagged(11)) {
            if (supType.isTagged(11)) {
                return ((Type.ArrayType)((Object)this)).elementType().isSubtypeOf(((Type.ArrayType)((Object)supType)).elementType());
            }
            return "java.lang.Object".equals(supType.fullyQualifiedName());
        }
        if (this.isTagged(15)) {
            return this.equals(superType) || this.erasure().isSubtypeOf(superType.erasure());
        }
        return false;
    }

    @Override
    public JavaType erasure() {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return this.tag <= 8;
    }

    @Override
    public boolean isPrimitive(Type.Primitives primitive) {
        return this.tag == primitive.ordinal() + 1;
    }

    @Override
    public boolean isUnknown() {
        return this.isTagged(14);
    }

    public boolean isPrimitiveWrapper() {
        if (!this.isTagged(10)) {
            return false;
        }
        return this.is("java.lang.Byte") || this.is("java.lang.Character") || this.is("java.lang.Short") || this.is("java.lang.Integer") || this.is("java.lang.Long") || this.is("java.lang.Float") || this.is("java.lang.Double") || this.is("java.lang.Boolean");
    }

    public String toString() {
        return this.symbol == null ? "" : this.symbol.toString();
    }

    @Nullable
    public JavaType primitiveType() {
        return this.primitiveType;
    }

    @Nullable
    public JavaType primitiveWrapperType() {
        return this.primitiveWrapperType;
    }

    @Override
    public boolean isArray() {
        return this.isTagged(11);
    }

    @Override
    public boolean isClass() {
        return this.isTagged(10);
    }

    @Override
    public boolean isVoid() {
        return this.isTagged(9);
    }

    @Override
    public String fullyQualifiedName() {
        return this.symbol.getFullyQualifiedName();
    }

    @Override
    public String name() {
        return this.symbol.name;
    }

    @Override
    public Symbol.TypeSymbol symbol() {
        return this.getSymbol();
    }

    public static class ParametrizedTypeJavaType
    extends ClassJavaType {
        final TypeSubstitution typeSubstitution;
        final JavaType rawType;

        ParametrizedTypeJavaType(JavaSymbol.TypeJavaSymbol symbol, TypeSubstitution typeSubstitution) {
            super(symbol);
            this.rawType = symbol.getType();
            this.typeSubstitution = typeSubstitution;
        }

        @Override
        public JavaType erasure() {
            return this.rawType.erasure();
        }

        @Nullable
        public JavaType substitution(TypeVariableJavaType typeVariableType) {
            JavaType result = null;
            if (this.typeSubstitution != null) {
                result = this.typeSubstitution.substitutedType(typeVariableType);
            }
            return result;
        }

        public List<TypeVariableJavaType> typeParameters() {
            if (this.typeSubstitution != null) {
                return this.typeSubstitution.typeVariables();
            }
            return Lists.newArrayList();
        }
    }

    public static class TypeVariableJavaType
    extends JavaType {
        List<JavaType> bounds;

        public TypeVariableJavaType(JavaSymbol.TypeVariableJavaSymbol symbol) {
            super(15, symbol);
        }

        @Override
        public JavaType erasure() {
            return this.bounds.get(0);
        }
    }

    public static class MethodJavaType
    extends JavaType {
        List<JavaType> argTypes;
        @Nullable
        JavaType resultType;
        List<JavaType> thrown;

        public MethodJavaType(List<JavaType> argTypes, @Nullable JavaType resultType, List<JavaType> thrown, JavaSymbol.TypeJavaSymbol symbol) {
            super(12, symbol);
            this.argTypes = argTypes;
            this.resultType = resultType;
            this.thrown = thrown;
        }

        @Override
        public String toString() {
            return this.resultType == null ? "constructor" : "returns " + this.resultType.toString();
        }
    }

    public static class ArrayJavaType
    extends JavaType
    implements Type.ArrayType {
        private final ArrayJavaType erasure;
        JavaType elementType;

        public ArrayJavaType(JavaType elementType, JavaSymbol.TypeJavaSymbol arrayClass) {
            super(11, arrayClass);
            this.elementType = elementType;
            this.erasure = new ArrayJavaType(arrayClass);
        }

        private ArrayJavaType(JavaSymbol.TypeJavaSymbol arrayClass) {
            super(11, arrayClass);
            this.erasure = this;
        }

        public int hashCode() {
            return new HashCodeBuilder(31, 37).append((Object)this.elementType).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ArrayJavaType)) {
                return false;
            }
            ArrayJavaType rhs = (ArrayJavaType)obj;
            return new EqualsBuilder().append((Object)this.elementType, (Object)rhs.elementType).isEquals();
        }

        @Override
        public String toString() {
            return this.elementType.toString() + "[]";
        }

        @Override
        public JavaType elementType() {
            return this.elementType;
        }

        @Override
        public JavaType erasure() {
            if (this.erasure.elementType == null) {
                this.erasure.elementType = this.elementType.erasure();
            }
            return this.erasure;
        }
    }

    public static class ClassJavaType
    extends JavaType {
        JavaType supertype;
        List<JavaType> interfaces;

        public ClassJavaType(JavaSymbol.TypeJavaSymbol symbol) {
            super(10, symbol);
        }

        @Override
        public boolean is(String fullyQualifiedName) {
            return this.isTagged(13) || fullyQualifiedName.equals(this.symbol.getFullyQualifiedName());
        }

        @Override
        public boolean isSubtypeOf(String fullyQualifiedName) {
            return this.isTagged(13) || this.is(fullyQualifiedName) || this.superTypeContains(fullyQualifiedName);
        }

        @Override
        public boolean isSubtypeOf(Type superType) {
            if (this.isTagged(14)) {
                return false;
            }
            if (this.isTagged(13)) {
                return ((JavaType)superType).isTagged(13) || superType.isClass() || superType.isArray();
            }
            if (superType.isClass()) {
                ClassJavaType superClassType = (ClassJavaType)superType;
                return this.equals(superClassType) || this.superTypeContains(superClassType.fullyQualifiedName());
            }
            return false;
        }

        private boolean superTypeContains(String fullyQualifiedName) {
            for (ClassJavaType classType : this.symbol.superTypes()) {
                if (!classType.is(fullyQualifiedName)) continue;
                return true;
            }
            return false;
        }
    }
}

