/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.Types;

public class Resolve {
    private final JavaSymbolNotFound symbolNotFound = new JavaSymbolNotFound();
    private final BytecodeCompleter bytecodeCompleter;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Types types = new Types();
    private final Symbols symbols;

    public Resolve(Symbols symbols, BytecodeCompleter bytecodeCompleter, ParametrizedTypeCache parametrizedTypeCache) {
        this.symbols = symbols;
        this.bytecodeCompleter = bytecodeCompleter;
        this.parametrizedTypeCache = parametrizedTypeCache;
    }

    @Nullable
    private static JavaSymbol.TypeJavaSymbol superclassSymbol(JavaSymbol.TypeJavaSymbol c) {
        JavaType supertype = c.getSuperclass();
        return supertype == null ? null : supertype.symbol;
    }

    public JavaSymbol.TypeJavaSymbol registerClass(JavaSymbol.TypeJavaSymbol classSymbol) {
        return this.bytecodeCompleter.registerClass(classSymbol);
    }

    public Scope createStarImportScope(JavaSymbol owner) {
        return new Scope.StarImportScope(owner, this.bytecodeCompleter);
    }

    public Scope createStaticStarImportScope(JavaSymbol owner) {
        return new Scope.StaticStarImportScope(owner, this.bytecodeCompleter);
    }

    public JavaType resolveTypeSubstitution(JavaType type, JavaType definition) {
        if (definition instanceof JavaType.ParametrizedTypeJavaType) {
            return this.substituteTypeParameter(type, ((JavaType.ParametrizedTypeJavaType)definition).typeSubstitution);
        }
        return type;
    }

    private JavaType substituteTypeParameter(JavaType type, TypeSubstitution substitution) {
        JavaType substitutedType = substitution.substitutedType(type);
        if (substitutedType != null) {
            return substitutedType;
        }
        if (type instanceof JavaType.ParametrizedTypeJavaType) {
            JavaType.ParametrizedTypeJavaType ptt = (JavaType.ParametrizedTypeJavaType)type;
            TypeSubstitution newSubstitution = new TypeSubstitution();
            for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> entry : ptt.typeSubstitution.substitutionEntries()) {
                newSubstitution.add(entry.getKey(), this.substituteTypeParameter(entry.getValue(), substitution));
            }
            return this.parametrizedTypeCache.getParametrizedTypeType(ptt.rawType.getSymbol(), newSubstitution);
        }
        return type;
    }

    private Resolution findField(Env env, JavaSymbol.TypeJavaSymbol site, String name, JavaSymbol.TypeJavaSymbol c) {
        Resolution bestSoFar = this.unresolved();
        Resolution resolution = new Resolution();
        for (JavaSymbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 4) continue;
            if (this.isAccessible(env, site, symbol)) {
                resolution.symbol = symbol;
                resolution.type = this.resolveTypeSubstitution(symbol.type, c.type);
                return resolution;
            }
            return Resolution.resolution(new AccessErrorJavaSymbol(symbol, Symbols.unknownType));
        }
        if (c.getSuperclass() != null) {
            resolution = this.findField(env, site, name, c.getSuperclass().symbol);
            if (((Resolution)resolution).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                resolution.type = this.resolveTypeSubstitution(((Resolution)resolution).symbol.type, c.getSuperclass());
                bestSoFar = resolution;
            }
        }
        for (JavaType interfaceType : c.getInterfaces()) {
            resolution = this.findField(env, site, name, interfaceType.symbol);
            if (((Resolution)resolution).symbol.kind >= ((Resolution)bestSoFar).symbol.kind) continue;
            bestSoFar = resolution;
        }
        return bestSoFar;
    }

    private Resolution findVar(Env env, String name) {
        Resolution bestSoFar = this.unresolved();
        Env env1 = env;
        while (env1.outer() != null) {
            Resolution sym = new Resolution();
            for (JavaSymbol symbol : env1.scope().lookup(name)) {
                if (symbol.kind != 4) continue;
                sym.symbol = symbol;
            }
            if (sym.symbol == null) {
                sym = this.findField(env1, env1.enclosingClass(), name, env1.enclosingClass());
            }
            if (((Resolution)sym).symbol.kind < 64) {
                return sym;
            }
            if (((Resolution)sym).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = sym;
            }
            env1 = env1.outer();
        }
        JavaSymbol symbol = this.findInStaticImport(env, name, 4);
        if (symbol.kind < 64) {
            return Resolution.resolution(symbol);
        }
        if (symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
            bestSoFar = Resolution.resolution(symbol);
        }
        return bestSoFar;
    }

    private JavaSymbol findInStaticImport(Env env, String name, int kind) {
        JavaSymbolNotFound bestSoFar = this.symbolNotFound;
        for (JavaSymbol symbol : env.namedImports().lookup(name)) {
            if ((kind & symbol.kind) == 0) continue;
            return symbol;
        }
        for (JavaSymbol symbol : env.staticStarImports().lookup(name)) {
            if ((kind & symbol.kind) == 0) continue;
            return symbol;
        }
        return bestSoFar;
    }

    private JavaSymbol findMemberType(Env env, JavaSymbol.TypeJavaSymbol site, String name, JavaSymbol.TypeJavaSymbol c) {
        JavaSymbol bestSoFar = this.symbolNotFound;
        for (JavaSymbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 2) continue;
            return this.isAccessible(env, site, symbol) ? symbol : new AccessErrorJavaSymbol(symbol, Symbols.unknownType);
        }
        if (c.getSuperclass() != null) {
            JavaSymbol symbol = this.findMemberType(env, site, name, c.getSuperclass().symbol);
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        for (JavaType interfaceType : c.getInterfaces()) {
            JavaSymbol symbol = this.findMemberType(env, site, name, interfaceType.symbol);
            if (symbol.kind >= bestSoFar.kind) continue;
            bestSoFar = symbol;
        }
        return bestSoFar;
    }

    private JavaSymbol findType(Env env, String name) {
        JavaSymbol bestSoFar = this.symbolNotFound;
        for (Env env1 = env; env1 != null; env1 = env1.outer()) {
            for (JavaSymbol symbol : env1.scope().lookup(name)) {
                if (symbol.kind != 2) continue;
                return symbol;
            }
            if (env1.outer == null) continue;
            JavaSymbol symbol = this.findMemberType(env1, env1.enclosingClass(), name, env1.enclosingClass());
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind >= bestSoFar.kind) continue;
            bestSoFar = symbol;
        }
        JavaSymbol predefinedSymbol = this.findMemberType(env, this.symbols.predefClass, name, this.symbols.predefClass);
        if (predefinedSymbol.kind < bestSoFar.kind) {
            return predefinedSymbol;
        }
        for (JavaSymbol symbol : env.namedImports().lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        JavaSymbol sym = this.findIdentInPackage(env.packge(), name, 2);
        if (sym.kind < bestSoFar.kind) {
            return sym;
        }
        for (JavaSymbol symbol : env.starImports().lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        JavaSymbol.PackageJavaSymbol javaLang = this.bytecodeCompleter.enterPackage("java.lang");
        for (JavaSymbol symbol : javaLang.members().lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        return bestSoFar;
    }

    public Resolution findIdent(Env env, String name, int kind) {
        Resolution res;
        Resolution bestSoFar = this.unresolved();
        if ((kind & 4) != 0) {
            res = this.findVar(env, name);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        if ((kind & 2) != 0) {
            res = new Resolution();
            res.symbol = this.findType(env, name);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        if ((kind & 1) != 0) {
            res = new Resolution();
            res.symbol = this.findIdentInPackage(this.symbols.defaultPackage, name, 1);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        return bestSoFar;
    }

    public JavaSymbol findIdentInPackage(JavaSymbol site, String name, int kind) {
        String fullname = this.bytecodeCompleter.formFullName(name, site);
        JavaSymbol bestSoFar = this.symbolNotFound;
        if ((kind & 2) != 0) {
            JavaSymbol sym = this.bytecodeCompleter.loadClass(fullname);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 1) != 0 && bestSoFar.kind >= this.symbolNotFound.kind) {
            bestSoFar = this.bytecodeCompleter.enterPackage(fullname);
        }
        return bestSoFar;
    }

    public JavaSymbol findIdentInType(Env env, JavaSymbol.TypeJavaSymbol site, String name, int kind) {
        JavaSymbol symbol;
        JavaSymbol bestSoFar = this.symbolNotFound;
        if ((kind & 4) != 0) {
            symbol = this.findField(env, site, name, site).symbol;
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        if ((kind & 2) != 0) {
            symbol = this.findMemberType(env, site, name, site);
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        return bestSoFar;
    }

    public Resolution findMethod(Env env, String name, List<JavaType> argTypes, List<JavaType> typeParamTypes) {
        Resolution bestSoFar = this.unresolved();
        Env env1 = env;
        while (env1.outer() != null) {
            Resolution res = this.findMethod(env1, env1.enclosingClass().getType(), name, argTypes, typeParamTypes);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
            env1 = env1.outer;
        }
        JavaSymbol sym = this.findInStaticImport(env, name, 16);
        if (sym.kind < 64) {
            return Resolution.resolution(sym);
        }
        if (sym.kind < ((Resolution)bestSoFar).symbol.kind) {
            bestSoFar = Resolution.resolution(sym);
        }
        return bestSoFar;
    }

    public Resolution findMethod(Env env, JavaType site, String name, List<JavaType> argTypes) {
        return this.findMethod(env, site, name, argTypes, (List<JavaType>)ImmutableList.of(), false);
    }

    public Resolution findMethod(Env env, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams) {
        return this.findMethod(env, site, name, argTypes, typeParams, false);
    }

    private Resolution findMethod(Env env, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams, boolean autoboxing) {
        Resolution bestSoFar = this.unresolved();
        for (JavaSymbol symbol : site.getSymbol().members().lookup(name)) {
            JavaSymbol best;
            if (symbol.kind != 16 || (best = this.selectBest(env, site.getSymbol(), argTypes, symbol, bestSoFar.symbol, autoboxing)) != symbol) continue;
            bestSoFar = Resolution.resolution(best);
            bestSoFar.type = this.resolveTypeSubstitution(((JavaType.MethodJavaType)best.type).resultType, site);
            JavaSymbol.MethodJavaSymbol methodSymbol = (JavaSymbol.MethodJavaSymbol)best;
            bestSoFar.type = this.handleTypeArguments(typeParams, bestSoFar.type, methodSymbol);
        }
        if (site.getSymbol().getSuperclass() != null) {
            Resolution method = this.findMethod(env, site.getSymbol().getSuperclass(), name, argTypes, typeParams);
            JavaSymbol best = this.selectBest(env, site.getSymbol(), argTypes, method.symbol, bestSoFar.symbol, autoboxing);
            if (best == method.symbol) {
                bestSoFar = method;
            }
        }
        for (JavaType interfaceType : site.getSymbol().getInterfaces()) {
            Resolution method = this.findMethod(env, interfaceType, name, argTypes, typeParams);
            JavaSymbol best = this.selectBest(env, site.getSymbol(), argTypes, method.symbol, bestSoFar.symbol, autoboxing);
            if (best != method.symbol) continue;
            bestSoFar = method;
        }
        if (((Resolution)bestSoFar).symbol.kind >= 64 && !autoboxing) {
            bestSoFar = this.findMethod(env, site, name, argTypes, typeParams, true);
        }
        return bestSoFar;
    }

    private JavaType handleTypeArguments(List<JavaType> typeParams, JavaType type, JavaSymbol.MethodJavaSymbol methodSymbol) {
        if (!typeParams.isEmpty() && methodSymbol.typeVariableTypes.size() == typeParams.size()) {
            TypeSubstitution typeSubstitution = new TypeSubstitution();
            int i = 0;
            for (JavaType.TypeVariableJavaType typeVariableType : methodSymbol.typeVariableTypes) {
                typeSubstitution.add(typeVariableType, typeParams.get(i));
                ++i;
            }
            return this.substituteTypeParameter(type, typeSubstitution);
        }
        return type;
    }

    private JavaSymbol selectBest(Env env, JavaSymbol.TypeJavaSymbol site, List<JavaType> argTypes, JavaSymbol symbol, JavaSymbol bestSoFar, boolean autoboxing) {
        if (symbol.kind >= 64 || !this.isInheritedIn(symbol, site) || symbol.type == null) {
            return bestSoFar;
        }
        boolean isVarArgs = ((JavaSymbol.MethodJavaSymbol)symbol).isVarArgs();
        if (!this.isArgumentsAcceptable(argTypes, ((JavaType.MethodJavaType)symbol.type).argTypes, isVarArgs, autoboxing)) {
            return bestSoFar;
        }
        if (!this.isAccessible(env, site, symbol)) {
            return new AccessErrorJavaSymbol(symbol, Symbols.unknownType);
        }
        JavaSymbol mostSpecific = this.selectMostSpecific(symbol, bestSoFar, argTypes);
        if (mostSpecific.isKind(65)) {
            mostSpecific = bestSoFar;
        }
        return mostSpecific;
    }

    private boolean isArgumentsAcceptable(List<JavaType> argTypes, List<JavaType> formals, boolean isVarArgs, boolean autoboxing) {
        int i;
        int argsSize = argTypes.size();
        int formalsSize = formals.size();
        int nbArgToCheck = argsSize - formalsSize;
        if (isVarArgs ? ++nbArgToCheck < 0 : nbArgToCheck != 0) {
            return false;
        }
        for (i = 1; i <= nbArgToCheck; ++i) {
            JavaType.ArrayJavaType lastFormal = (JavaType.ArrayJavaType)formals.get(formalsSize - 1);
            JavaType argType = argTypes.get(argsSize - i);
            if (this.isAcceptableType(argType, lastFormal.elementType, autoboxing) || nbArgToCheck == 1 && this.types.isSubtype(argType, lastFormal)) continue;
            return false;
        }
        for (i = 0; i < argsSize - nbArgToCheck; ++i) {
            if (this.isAcceptableType(argTypes.get(i), formals.get(i), autoboxing)) continue;
            return false;
        }
        return true;
    }

    private boolean isAcceptableType(JavaType arg, JavaType formal, boolean autoboxing) {
        return this.types.isSubtype(arg.erasure(), formal.erasure()) || autoboxing && this.isAcceptableByAutoboxing(arg, formal.erasure());
    }

    private boolean isAcceptableByAutoboxing(JavaType expressionType, JavaType formalType) {
        if (expressionType.isPrimitive()) {
            return this.types.isSubtype((JavaType)this.symbols.boxedTypes.get((Object)expressionType), formalType);
        }
        JavaType unboxedType = (JavaType)this.symbols.boxedTypes.inverse().get((Object)expressionType);
        if (unboxedType != null) {
            return this.types.isSubtype(unboxedType, formalType);
        }
        return false;
    }

    private JavaSymbol selectMostSpecific(JavaSymbol m1, JavaSymbol m2, List<JavaType> argTypes) {
        if (m2.type == null || !m2.isKind(16)) {
            return m1;
        }
        boolean m1SignatureMoreSpecific = this.isSignatureMoreSpecific(m1, m2);
        boolean m2SignatureMoreSpecific = this.isSignatureMoreSpecific(m2, m1);
        if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
            return new AmbiguityErrorJavaSymbol();
        }
        if (m1SignatureMoreSpecific) {
            return m1;
        }
        if (m2SignatureMoreSpecific) {
            return m2;
        }
        return new AmbiguityErrorJavaSymbol();
    }

    private boolean isSignatureMoreSpecific(JavaSymbol m1, JavaSymbol m2) {
        return this.isArgumentsAcceptable(((JavaType.MethodJavaType)m1.type).argTypes, ((JavaType.MethodJavaType)m2.type).argTypes, false, false);
    }

    @VisibleForTesting
    boolean isAccessible(Env env, JavaSymbol.TypeJavaSymbol c) {
        boolean result;
        switch (c.flags() & 7) {
            case 2: {
                result = env.enclosingClass().outermostClass() == ((JavaSymbol)c.owner()).outermostClass();
                break;
            }
            case 0: {
                result = env.packge() == c.packge();
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 4: {
                result = env.packge() == c.packge() || this.isInnerSubClass(env.enclosingClass(), (JavaSymbol)c.owner());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    private boolean isInnerSubClass(JavaSymbol.TypeJavaSymbol c, JavaSymbol base) {
        while (c != null && this.isSubClass(c, base)) {
            c = ((JavaSymbol)c.owner()).enclosingClass();
        }
        return c != null;
    }

    @VisibleForTesting
    boolean isSubClass(JavaSymbol.TypeJavaSymbol c, JavaSymbol base) {
        if (c == null) {
            return false;
        }
        if (c == base) {
            return true;
        }
        if ((base.flags() & 0x200) != 0) {
            for (JavaType interfaceType : c.getInterfaces()) {
                if (!this.isSubClass(interfaceType.symbol, base)) continue;
                return true;
            }
            return this.isSubClass(Resolve.superclassSymbol(c), base);
        }
        return this.isSubClass(Resolve.superclassSymbol(c), base);
    }

    private boolean isAccessible(Env env, JavaSymbol.TypeJavaSymbol site, JavaSymbol symbol) {
        switch (symbol.flags() & 7) {
            case 2: {
                return env.enclosingClass != null && env.enclosingClass().outermostClass() == symbol.owner().outermostClass() && this.isInheritedIn(symbol, site);
            }
            case 0: {
                return env.packge() == symbol.packge() && this.isAccessible(env, site) && this.isInheritedIn(symbol, site) && this.notOverriddenIn(site, symbol);
            }
            case 1: {
                return this.isAccessible(env, site) && this.notOverriddenIn(site, symbol);
            }
            case 4: {
                return (env.packge() == symbol.packge() || this.isProtectedAccessible(symbol, env.enclosingClass, site)) && this.isAccessible(env, site) && this.notOverriddenIn(site, symbol);
            }
        }
        throw new IllegalStateException();
    }

    private boolean notOverriddenIn(JavaSymbol.TypeJavaSymbol site, JavaSymbol symbol) {
        return true;
    }

    @VisibleForTesting
    boolean isInheritedIn(JavaSymbol symbol, JavaSymbol.TypeJavaSymbol clazz) {
        switch (symbol.flags() & 7) {
            case 1: {
                return true;
            }
            case 2: {
                return symbol.owner() == clazz;
            }
            case 4: {
                return true;
            }
            case 0: {
                JavaSymbol.PackageJavaSymbol thisPackage = symbol.packge();
                JavaSymbol.TypeJavaSymbol sup = clazz;
                while (sup != null && sup != symbol.owner()) {
                    if (sup.packge() != thisPackage) {
                        return false;
                    }
                    sup = Resolve.superclassSymbol(sup);
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean isProtectedAccessible(JavaSymbol symbol, JavaSymbol.TypeJavaSymbol c, JavaSymbol.TypeJavaSymbol site) {
        return true;
    }

    private Resolution unresolved() {
        Resolution resolution = new Resolution(this.symbolNotFound);
        resolution.type = Symbols.unknownType;
        return resolution;
    }

    public static class AccessErrorJavaSymbol
    extends JavaSymbol {
        JavaSymbol symbol;

        public AccessErrorJavaSymbol(JavaSymbol symbol, JavaType type) {
            super(64, 0, null, null);
            this.symbol = symbol;
            this.type = type;
        }
    }

    public static class AmbiguityErrorJavaSymbol
    extends JavaSymbol {
        public AmbiguityErrorJavaSymbol() {
            super(65, 0, null, null);
        }
    }

    public static class JavaSymbolNotFound
    extends JavaSymbol {
        public JavaSymbolNotFound() {
            super(66, 0, null, null);
        }
    }

    static class Env {
        Env next;
        Env outer;
        JavaSymbol.PackageJavaSymbol packge;
        JavaSymbol.TypeJavaSymbol enclosingClass;
        Scope scope;
        Scope namedImports;
        Scope starImports;
        Scope staticStarImports;

        Env() {
        }

        @Nullable
        Env outer() {
            return this.outer;
        }

        JavaSymbol.TypeJavaSymbol enclosingClass() {
            return this.enclosingClass;
        }

        public JavaSymbol.PackageJavaSymbol packge() {
            return this.packge;
        }

        Scope namedImports() {
            return this.namedImports;
        }

        Scope starImports() {
            return this.starImports;
        }

        public Scope staticStarImports() {
            return this.staticStarImports;
        }

        Scope scope() {
            return this.scope;
        }

        public Env dup() {
            Env env = new Env();
            env.next = this;
            env.outer = this.outer;
            env.packge = this.packge;
            env.enclosingClass = this.enclosingClass;
            env.scope = this.scope;
            env.namedImports = this.namedImports;
            env.starImports = this.starImports;
            env.staticStarImports = this.staticStarImports;
            return env;
        }
    }

    static class Resolution {
        private JavaSymbol symbol;
        private JavaType type;

        private Resolution(JavaSymbol symbol) {
            this.symbol = symbol;
        }

        Resolution() {
        }

        static Resolution resolution(JavaSymbol symbol) {
            return new Resolution(symbol);
        }

        JavaSymbol symbol() {
            return this.symbol;
        }

        public JavaType type() {
            if (this.type == null) {
                if (this.symbol.isKind(16)) {
                    return ((JavaType.MethodJavaType)this.symbol.type).resultType;
                }
                return this.symbol.type;
            }
            return this.type;
        }
    }
}

