/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import java.util.Locale;
import java.util.Set;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Violation;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;

public class ChecksBridge
extends Bridge {
    protected ChecksBridge() {
        super(false);
    }

    @Override
    public void onFile(SourceFile squidFile, Resource sonarFile) {
        Set messages = squidFile.getCheckMessages();
        if (messages != null) {
            for (CheckMessage checkMessage : messages) {
                ActiveRule rule = this.checkFactory.getActiveRule(checkMessage.getCheck());
                Violation violation = Violation.create((ActiveRule)rule, (Resource)sonarFile);
                violation.setLineId(checkMessage.getLine());
                violation.setMessage(checkMessage.getText(Locale.ENGLISH));
                violation.setCost(checkMessage.getCost());
                this.context.saveViolation(violation, checkMessage.isBypassExclusion());
            }
        }
    }
}

