/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.SquidUtils;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.JavaPackage;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.java.JavaSquid;
import org.sonar.java.api.JavaClass;
import org.sonar.java.api.JavaMethod;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByMeasure;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.indexer.SquidIndex;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public final class ResourceIndex
extends HashMap<SourceCode, Resource> {
    private static final long serialVersionUID = -918346378374943773L;

    public ResourceIndex loadSquidResources(JavaSquid squid, SensorContext context, Project project) {
        this.loadSquidProject(squid.getIndex(), project);
        this.loadSquidPackages(squid.getIndex(), context);
        this.loadSquidFiles(squid.getIndex(), context);
        this.loadSquidClasses(squid.getIndex(), context);
        this.loadSquidMethods(squid.getIndex(), context);
        return this;
    }

    private void loadSquidProject(SquidIndex squid, Project project) {
        this.put(squid.search(new Query[]{new QueryByType(SourceProject.class)}).iterator().next(), project);
    }

    private void loadSquidPackages(SquidIndex squid, SensorContext context) {
        Collection packages = squid.search(new Query[]{new QueryByType(SourcePackage.class)});
        for (SourceCode squidPackage : packages) {
            JavaPackage sonarPackage = SquidUtils.convertJavaPackageKeyFromSquidFormat((String)squidPackage.getKey());
            context.index((Resource)sonarPackage);
            this.put(squidPackage, context.getResource((Resource)sonarPackage));
        }
    }

    private void loadSquidFiles(SquidIndex squid, SensorContext context) {
        Collection files = squid.search(new Query[]{new QueryByType(SourceFile.class)});
        for (SourceCode squidFile : files) {
            JavaFile sonarFile = SquidUtils.convertJavaFileKeyFromSquidFormat((String)squidFile.getKey());
            JavaPackage sonarPackage = (JavaPackage)this.get(squidFile.getParent(SourcePackage.class));
            context.index((Resource)sonarFile, (Resource)sonarPackage);
            this.put(squidFile, context.getResource((Resource)sonarFile));
        }
    }

    private void loadSquidClasses(SquidIndex squid, SensorContext context) {
        Collection classes = squid.search(new Query[]{new QueryByType(SourceClass.class), new QueryByMeasure((MetricDef)JavaMetric.CLASSES, QueryByMeasure.Operator.GREATER_THAN_EQUALS, 1.0)});
        for (SourceCode squidClass : classes) {
            JavaFile sonarFile = (JavaFile)this.get(squidClass.getParent(SourceFile.class));
            JavaClass sonarClass = new JavaClass.Builder().setName(ResourceIndex.convertClassKey(squidClass.getKey())).setFromLine(squidClass.getStartAtLine()).setToLine(squidClass.getEndAtLine()).create();
            context.index((Resource)sonarClass, (Resource)sonarFile);
            this.put(squidClass, sonarClass);
        }
    }

    private void loadSquidMethods(SquidIndex squid, SensorContext context) {
        Collection methods = squid.search(new Query[]{new QueryByType(SourceMethod.class)});
        for (SourceCode squidMethod : methods) {
            SourceClass squidClass = (SourceClass)squidMethod.getParent(SourceClass.class);
            JavaClass sonarClass = (JavaClass)this.get(squidClass);
            if (sonarClass == null) continue;
            JavaMethod sonarMethod = new JavaMethod.Builder().setClass(sonarClass).setSignature(squidMethod.getName()).setFromLine(squidMethod.getStartAtLine()).setToLine(squidMethod.getEndAtLine()).setAccessor(squidMethod.getInt(Metric.ACCESSORS) > 0).create();
            context.index((Resource)sonarMethod, (Resource)sonarClass);
            this.put(squidMethod, sonarMethod);
        }
    }

    static String convertClassKey(String squidClassKey) {
        return StringUtils.replace((String)squidClassKey, (String)"/", (String)".");
    }
}

